package io.fabric8.volcano.api.model.flow.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class JobFlowBuilder extends JobFlowFluent<JobFlowBuilder> implements VisitableBuilder<JobFlow,JobFlowBuilder>{
  public JobFlowBuilder() {
    this(new JobFlow());
  }
  
  public JobFlowBuilder(JobFlowFluent<?> fluent) {
    this(fluent, new JobFlow());
  }
  
  public JobFlowBuilder(JobFlowFluent<?> fluent,JobFlow instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public JobFlowBuilder(JobFlow instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  JobFlowFluent<?> fluent;
  
  public JobFlow build() {
    JobFlow buildable = new JobFlow(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}