/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volcano.api.model.flow.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.volcano.api.model.flow.v1alpha1.Condition;
import io.fabric8.volcano.api.model.flow.v1alpha1.JobFlowStatus;
import io.fabric8.volcano.api.model.flow.v1alpha1.JobStatus;
import io.fabric8.volcano.api.model.flow.v1alpha1.JobStatusBuilder;
import io.fabric8.volcano.api.model.flow.v1alpha1.JobStatusFluent;
import io.fabric8.volcano.api.model.flow.v1alpha1.State;
import io.fabric8.volcano.api.model.flow.v1alpha1.StateBuilder;
import io.fabric8.volcano.api.model.flow.v1alpha1.StateFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class JobFlowStatusFluent<A extends JobFlowStatusFluent<A>>
extends BaseFluent<A> {
    private List<String> completedJobs = new ArrayList<String>();
    private Map<String, Condition> conditions;
    private List<String> failedJobs = new ArrayList<String>();
    private ArrayList<JobStatusBuilder> jobStatusList = new ArrayList();
    private List<String> pendingJobs = new ArrayList<String>();
    private List<String> runningJobs = new ArrayList<String>();
    private StateBuilder state;
    private List<String> terminatedJobs = new ArrayList<String>();
    private List<String> unKnowJobs = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public JobFlowStatusFluent() {
    }

    public JobFlowStatusFluent(JobFlowStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(JobFlowStatus instance) {
        JobFlowStatus jobFlowStatus = instance = instance != null ? instance : new JobFlowStatus();
        if (instance != null) {
            this.withCompletedJobs(instance.getCompletedJobs());
            this.withConditions(instance.getConditions());
            this.withFailedJobs(instance.getFailedJobs());
            this.withJobStatusList(instance.getJobStatusList());
            this.withPendingJobs(instance.getPendingJobs());
            this.withRunningJobs(instance.getRunningJobs());
            this.withState(instance.getState());
            this.withTerminatedJobs(instance.getTerminatedJobs());
            this.withUnKnowJobs(instance.getUnKnowJobs());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToCompletedJobs(int index, String item) {
        if (this.completedJobs == null) {
            this.completedJobs = new ArrayList<String>();
        }
        this.completedJobs.add(index, item);
        return (A)((Object)this);
    }

    public A setToCompletedJobs(int index, String item) {
        if (this.completedJobs == null) {
            this.completedJobs = new ArrayList<String>();
        }
        this.completedJobs.set(index, item);
        return (A)((Object)this);
    }

    public A addToCompletedJobs(String ... items) {
        if (this.completedJobs == null) {
            this.completedJobs = new ArrayList<String>();
        }
        for (String item : items) {
            this.completedJobs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCompletedJobs(Collection<String> items) {
        if (this.completedJobs == null) {
            this.completedJobs = new ArrayList<String>();
        }
        for (String item : items) {
            this.completedJobs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCompletedJobs(String ... items) {
        if (this.completedJobs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.completedJobs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCompletedJobs(Collection<String> items) {
        if (this.completedJobs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.completedJobs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getCompletedJobs() {
        return this.completedJobs;
    }

    public String getCompletedJob(int index) {
        return this.completedJobs.get(index);
    }

    public String getFirstCompletedJob() {
        return this.completedJobs.get(0);
    }

    public String getLastCompletedJob() {
        return this.completedJobs.get(this.completedJobs.size() - 1);
    }

    public String getMatchingCompletedJob(Predicate<String> predicate) {
        for (String item : this.completedJobs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCompletedJob(Predicate<String> predicate) {
        for (String item : this.completedJobs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCompletedJobs(List<String> completedJobs) {
        if (completedJobs != null) {
            this.completedJobs = new ArrayList<String>();
            for (String item : completedJobs) {
                this.addToCompletedJobs(item);
            }
        } else {
            this.completedJobs = null;
        }
        return (A)((Object)this);
    }

    public A withCompletedJobs(String ... completedJobs) {
        if (this.completedJobs != null) {
            this.completedJobs.clear();
            this._visitables.remove((Object)"completedJobs");
        }
        if (completedJobs != null) {
            for (String item : completedJobs) {
                this.addToCompletedJobs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCompletedJobs() {
        return this.completedJobs != null && !this.completedJobs.isEmpty();
    }

    public A addToConditions(String key, Condition value) {
        if (this.conditions == null && key != null && value != null) {
            this.conditions = new LinkedHashMap<String, Condition>();
        }
        if (key != null && value != null) {
            this.conditions.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConditions(Map<String, Condition> map) {
        if (this.conditions == null && map != null) {
            this.conditions = new LinkedHashMap<String, Condition>();
        }
        if (map != null) {
            this.conditions.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(String key) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        if (key != null && this.conditions != null) {
            this.conditions.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Map<String, Condition> map) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.conditions == null) continue;
                this.conditions.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Condition> getConditions() {
        return this.conditions;
    }

    public <K, V> A withConditions(Map<String, Condition> conditions) {
        this.conditions = conditions == null ? null : new LinkedHashMap<String, Condition>(conditions);
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null;
    }

    public A addToFailedJobs(int index, String item) {
        if (this.failedJobs == null) {
            this.failedJobs = new ArrayList<String>();
        }
        this.failedJobs.add(index, item);
        return (A)((Object)this);
    }

    public A setToFailedJobs(int index, String item) {
        if (this.failedJobs == null) {
            this.failedJobs = new ArrayList<String>();
        }
        this.failedJobs.set(index, item);
        return (A)((Object)this);
    }

    public A addToFailedJobs(String ... items) {
        if (this.failedJobs == null) {
            this.failedJobs = new ArrayList<String>();
        }
        for (String item : items) {
            this.failedJobs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToFailedJobs(Collection<String> items) {
        if (this.failedJobs == null) {
            this.failedJobs = new ArrayList<String>();
        }
        for (String item : items) {
            this.failedJobs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromFailedJobs(String ... items) {
        if (this.failedJobs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.failedJobs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromFailedJobs(Collection<String> items) {
        if (this.failedJobs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.failedJobs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getFailedJobs() {
        return this.failedJobs;
    }

    public String getFailedJob(int index) {
        return this.failedJobs.get(index);
    }

    public String getFirstFailedJob() {
        return this.failedJobs.get(0);
    }

    public String getLastFailedJob() {
        return this.failedJobs.get(this.failedJobs.size() - 1);
    }

    public String getMatchingFailedJob(Predicate<String> predicate) {
        for (String item : this.failedJobs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingFailedJob(Predicate<String> predicate) {
        for (String item : this.failedJobs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFailedJobs(List<String> failedJobs) {
        if (failedJobs != null) {
            this.failedJobs = new ArrayList<String>();
            for (String item : failedJobs) {
                this.addToFailedJobs(item);
            }
        } else {
            this.failedJobs = null;
        }
        return (A)((Object)this);
    }

    public A withFailedJobs(String ... failedJobs) {
        if (this.failedJobs != null) {
            this.failedJobs.clear();
            this._visitables.remove((Object)"failedJobs");
        }
        if (failedJobs != null) {
            for (String item : failedJobs) {
                this.addToFailedJobs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasFailedJobs() {
        return this.failedJobs != null && !this.failedJobs.isEmpty();
    }

    public A addToJobStatusList(int index, JobStatus item) {
        if (this.jobStatusList == null) {
            this.jobStatusList = new ArrayList();
        }
        JobStatusBuilder builder = new JobStatusBuilder(item);
        if (index < 0 || index >= this.jobStatusList.size()) {
            this._visitables.get((Object)"jobStatusList").add(builder);
            this.jobStatusList.add(builder);
        } else {
            this._visitables.get((Object)"jobStatusList").add(builder);
            this.jobStatusList.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToJobStatusList(int index, JobStatus item) {
        if (this.jobStatusList == null) {
            this.jobStatusList = new ArrayList();
        }
        JobStatusBuilder builder = new JobStatusBuilder(item);
        if (index < 0 || index >= this.jobStatusList.size()) {
            this._visitables.get((Object)"jobStatusList").add(builder);
            this.jobStatusList.add(builder);
        } else {
            this._visitables.get((Object)"jobStatusList").add(builder);
            this.jobStatusList.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToJobStatusList(JobStatus ... items) {
        if (this.jobStatusList == null) {
            this.jobStatusList = new ArrayList();
        }
        for (JobStatus item : items) {
            JobStatusBuilder builder = new JobStatusBuilder(item);
            this._visitables.get((Object)"jobStatusList").add(builder);
            this.jobStatusList.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToJobStatusList(Collection<JobStatus> items) {
        if (this.jobStatusList == null) {
            this.jobStatusList = new ArrayList();
        }
        for (JobStatus item : items) {
            JobStatusBuilder builder = new JobStatusBuilder(item);
            this._visitables.get((Object)"jobStatusList").add(builder);
            this.jobStatusList.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromJobStatusList(JobStatus ... items) {
        if (this.jobStatusList == null) {
            return (A)((Object)this);
        }
        for (JobStatus item : items) {
            JobStatusBuilder builder = new JobStatusBuilder(item);
            this._visitables.get((Object)"jobStatusList").remove((Object)builder);
            this.jobStatusList.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromJobStatusList(Collection<JobStatus> items) {
        if (this.jobStatusList == null) {
            return (A)((Object)this);
        }
        for (JobStatus item : items) {
            JobStatusBuilder builder = new JobStatusBuilder(item);
            this._visitables.get((Object)"jobStatusList").remove((Object)builder);
            this.jobStatusList.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromJobStatusList(Predicate<JobStatusBuilder> predicate) {
        if (this.jobStatusList == null) {
            return (A)((Object)this);
        }
        Iterator<JobStatusBuilder> each = this.jobStatusList.iterator();
        List visitables = this._visitables.get((Object)"jobStatusList");
        while (each.hasNext()) {
            JobStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<JobStatus> buildJobStatusList() {
        return this.jobStatusList != null ? JobFlowStatusFluent.build(this.jobStatusList) : null;
    }

    public JobStatus buildJobStatusList(int index) {
        return this.jobStatusList.get(index).build();
    }

    public JobStatus buildFirstJobStatusList() {
        return this.jobStatusList.get(0).build();
    }

    public JobStatus buildLastJobStatusList() {
        return this.jobStatusList.get(this.jobStatusList.size() - 1).build();
    }

    public JobStatus buildMatchingJobStatusList(Predicate<JobStatusBuilder> predicate) {
        for (JobStatusBuilder item : this.jobStatusList) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingJobStatusList(Predicate<JobStatusBuilder> predicate) {
        for (JobStatusBuilder item : this.jobStatusList) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withJobStatusList(List<JobStatus> jobStatusList) {
        if (this.jobStatusList != null) {
            this._visitables.get((Object)"jobStatusList").clear();
        }
        if (jobStatusList != null) {
            this.jobStatusList = new ArrayList();
            for (JobStatus item : jobStatusList) {
                this.addToJobStatusList(item);
            }
        } else {
            this.jobStatusList = null;
        }
        return (A)((Object)this);
    }

    public A withJobStatusList(JobStatus ... jobStatusList) {
        if (this.jobStatusList != null) {
            this.jobStatusList.clear();
            this._visitables.remove((Object)"jobStatusList");
        }
        if (jobStatusList != null) {
            for (JobStatus item : jobStatusList) {
                this.addToJobStatusList(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasJobStatusList() {
        return this.jobStatusList != null && !this.jobStatusList.isEmpty();
    }

    public JobStatusListNested<A> addNewJobStatusList() {
        return new JobStatusListNested(-1, null);
    }

    public JobStatusListNested<A> addNewJobStatusListLike(JobStatus item) {
        return new JobStatusListNested(-1, item);
    }

    public JobStatusListNested<A> setNewJobStatusListLike(int index, JobStatus item) {
        return new JobStatusListNested(index, item);
    }

    public JobStatusListNested<A> editJobStatusList(int index) {
        if (this.jobStatusList.size() <= index) {
            throw new RuntimeException("Can't edit jobStatusList. Index exceeds size.");
        }
        return this.setNewJobStatusListLike(index, this.buildJobStatusList(index));
    }

    public JobStatusListNested<A> editFirstJobStatusList() {
        if (this.jobStatusList.size() == 0) {
            throw new RuntimeException("Can't edit first jobStatusList. The list is empty.");
        }
        return this.setNewJobStatusListLike(0, this.buildJobStatusList(0));
    }

    public JobStatusListNested<A> editLastJobStatusList() {
        int index = this.jobStatusList.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last jobStatusList. The list is empty.");
        }
        return this.setNewJobStatusListLike(index, this.buildJobStatusList(index));
    }

    public JobStatusListNested<A> editMatchingJobStatusList(Predicate<JobStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.jobStatusList.size(); ++i) {
            if (!predicate.test(this.jobStatusList.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching jobStatusList. No match found.");
        }
        return this.setNewJobStatusListLike(index, this.buildJobStatusList(index));
    }

    public A addToPendingJobs(int index, String item) {
        if (this.pendingJobs == null) {
            this.pendingJobs = new ArrayList<String>();
        }
        this.pendingJobs.add(index, item);
        return (A)((Object)this);
    }

    public A setToPendingJobs(int index, String item) {
        if (this.pendingJobs == null) {
            this.pendingJobs = new ArrayList<String>();
        }
        this.pendingJobs.set(index, item);
        return (A)((Object)this);
    }

    public A addToPendingJobs(String ... items) {
        if (this.pendingJobs == null) {
            this.pendingJobs = new ArrayList<String>();
        }
        for (String item : items) {
            this.pendingJobs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToPendingJobs(Collection<String> items) {
        if (this.pendingJobs == null) {
            this.pendingJobs = new ArrayList<String>();
        }
        for (String item : items) {
            this.pendingJobs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromPendingJobs(String ... items) {
        if (this.pendingJobs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.pendingJobs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPendingJobs(Collection<String> items) {
        if (this.pendingJobs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.pendingJobs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getPendingJobs() {
        return this.pendingJobs;
    }

    public String getPendingJob(int index) {
        return this.pendingJobs.get(index);
    }

    public String getFirstPendingJob() {
        return this.pendingJobs.get(0);
    }

    public String getLastPendingJob() {
        return this.pendingJobs.get(this.pendingJobs.size() - 1);
    }

    public String getMatchingPendingJob(Predicate<String> predicate) {
        for (String item : this.pendingJobs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPendingJob(Predicate<String> predicate) {
        for (String item : this.pendingJobs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPendingJobs(List<String> pendingJobs) {
        if (pendingJobs != null) {
            this.pendingJobs = new ArrayList<String>();
            for (String item : pendingJobs) {
                this.addToPendingJobs(item);
            }
        } else {
            this.pendingJobs = null;
        }
        return (A)((Object)this);
    }

    public A withPendingJobs(String ... pendingJobs) {
        if (this.pendingJobs != null) {
            this.pendingJobs.clear();
            this._visitables.remove((Object)"pendingJobs");
        }
        if (pendingJobs != null) {
            for (String item : pendingJobs) {
                this.addToPendingJobs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPendingJobs() {
        return this.pendingJobs != null && !this.pendingJobs.isEmpty();
    }

    public A addToRunningJobs(int index, String item) {
        if (this.runningJobs == null) {
            this.runningJobs = new ArrayList<String>();
        }
        this.runningJobs.add(index, item);
        return (A)((Object)this);
    }

    public A setToRunningJobs(int index, String item) {
        if (this.runningJobs == null) {
            this.runningJobs = new ArrayList<String>();
        }
        this.runningJobs.set(index, item);
        return (A)((Object)this);
    }

    public A addToRunningJobs(String ... items) {
        if (this.runningJobs == null) {
            this.runningJobs = new ArrayList<String>();
        }
        for (String item : items) {
            this.runningJobs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToRunningJobs(Collection<String> items) {
        if (this.runningJobs == null) {
            this.runningJobs = new ArrayList<String>();
        }
        for (String item : items) {
            this.runningJobs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromRunningJobs(String ... items) {
        if (this.runningJobs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.runningJobs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRunningJobs(Collection<String> items) {
        if (this.runningJobs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.runningJobs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getRunningJobs() {
        return this.runningJobs;
    }

    public String getRunningJob(int index) {
        return this.runningJobs.get(index);
    }

    public String getFirstRunningJob() {
        return this.runningJobs.get(0);
    }

    public String getLastRunningJob() {
        return this.runningJobs.get(this.runningJobs.size() - 1);
    }

    public String getMatchingRunningJob(Predicate<String> predicate) {
        for (String item : this.runningJobs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingRunningJob(Predicate<String> predicate) {
        for (String item : this.runningJobs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRunningJobs(List<String> runningJobs) {
        if (runningJobs != null) {
            this.runningJobs = new ArrayList<String>();
            for (String item : runningJobs) {
                this.addToRunningJobs(item);
            }
        } else {
            this.runningJobs = null;
        }
        return (A)((Object)this);
    }

    public A withRunningJobs(String ... runningJobs) {
        if (this.runningJobs != null) {
            this.runningJobs.clear();
            this._visitables.remove((Object)"runningJobs");
        }
        if (runningJobs != null) {
            for (String item : runningJobs) {
                this.addToRunningJobs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRunningJobs() {
        return this.runningJobs != null && !this.runningJobs.isEmpty();
    }

    public State buildState() {
        return this.state != null ? this.state.build() : null;
    }

    public A withState(State state) {
        this._visitables.remove((Object)"state");
        if (state != null) {
            this.state = new StateBuilder(state);
            this._visitables.get((Object)"state").add(this.state);
        } else {
            this.state = null;
            this._visitables.get((Object)"state").remove((Object)this.state);
        }
        return (A)((Object)this);
    }

    public boolean hasState() {
        return this.state != null;
    }

    public A withNewState(String phase) {
        return this.withState(new State(phase));
    }

    public StateNested<A> withNewState() {
        return new StateNested(null);
    }

    public StateNested<A> withNewStateLike(State item) {
        return new StateNested(item);
    }

    public StateNested<A> editState() {
        return this.withNewStateLike(Optional.ofNullable(this.buildState()).orElse(null));
    }

    public StateNested<A> editOrNewState() {
        return this.withNewStateLike(Optional.ofNullable(this.buildState()).orElse(new StateBuilder().build()));
    }

    public StateNested<A> editOrNewStateLike(State item) {
        return this.withNewStateLike(Optional.ofNullable(this.buildState()).orElse(item));
    }

    public A addToTerminatedJobs(int index, String item) {
        if (this.terminatedJobs == null) {
            this.terminatedJobs = new ArrayList<String>();
        }
        this.terminatedJobs.add(index, item);
        return (A)((Object)this);
    }

    public A setToTerminatedJobs(int index, String item) {
        if (this.terminatedJobs == null) {
            this.terminatedJobs = new ArrayList<String>();
        }
        this.terminatedJobs.set(index, item);
        return (A)((Object)this);
    }

    public A addToTerminatedJobs(String ... items) {
        if (this.terminatedJobs == null) {
            this.terminatedJobs = new ArrayList<String>();
        }
        for (String item : items) {
            this.terminatedJobs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTerminatedJobs(Collection<String> items) {
        if (this.terminatedJobs == null) {
            this.terminatedJobs = new ArrayList<String>();
        }
        for (String item : items) {
            this.terminatedJobs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTerminatedJobs(String ... items) {
        if (this.terminatedJobs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.terminatedJobs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTerminatedJobs(Collection<String> items) {
        if (this.terminatedJobs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.terminatedJobs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getTerminatedJobs() {
        return this.terminatedJobs;
    }

    public String getTerminatedJob(int index) {
        return this.terminatedJobs.get(index);
    }

    public String getFirstTerminatedJob() {
        return this.terminatedJobs.get(0);
    }

    public String getLastTerminatedJob() {
        return this.terminatedJobs.get(this.terminatedJobs.size() - 1);
    }

    public String getMatchingTerminatedJob(Predicate<String> predicate) {
        for (String item : this.terminatedJobs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTerminatedJob(Predicate<String> predicate) {
        for (String item : this.terminatedJobs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTerminatedJobs(List<String> terminatedJobs) {
        if (terminatedJobs != null) {
            this.terminatedJobs = new ArrayList<String>();
            for (String item : terminatedJobs) {
                this.addToTerminatedJobs(item);
            }
        } else {
            this.terminatedJobs = null;
        }
        return (A)((Object)this);
    }

    public A withTerminatedJobs(String ... terminatedJobs) {
        if (this.terminatedJobs != null) {
            this.terminatedJobs.clear();
            this._visitables.remove((Object)"terminatedJobs");
        }
        if (terminatedJobs != null) {
            for (String item : terminatedJobs) {
                this.addToTerminatedJobs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTerminatedJobs() {
        return this.terminatedJobs != null && !this.terminatedJobs.isEmpty();
    }

    public A addToUnKnowJobs(int index, String item) {
        if (this.unKnowJobs == null) {
            this.unKnowJobs = new ArrayList<String>();
        }
        this.unKnowJobs.add(index, item);
        return (A)((Object)this);
    }

    public A setToUnKnowJobs(int index, String item) {
        if (this.unKnowJobs == null) {
            this.unKnowJobs = new ArrayList<String>();
        }
        this.unKnowJobs.set(index, item);
        return (A)((Object)this);
    }

    public A addToUnKnowJobs(String ... items) {
        if (this.unKnowJobs == null) {
            this.unKnowJobs = new ArrayList<String>();
        }
        for (String item : items) {
            this.unKnowJobs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToUnKnowJobs(Collection<String> items) {
        if (this.unKnowJobs == null) {
            this.unKnowJobs = new ArrayList<String>();
        }
        for (String item : items) {
            this.unKnowJobs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromUnKnowJobs(String ... items) {
        if (this.unKnowJobs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.unKnowJobs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromUnKnowJobs(Collection<String> items) {
        if (this.unKnowJobs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.unKnowJobs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getUnKnowJobs() {
        return this.unKnowJobs;
    }

    public String getUnKnowJob(int index) {
        return this.unKnowJobs.get(index);
    }

    public String getFirstUnKnowJob() {
        return this.unKnowJobs.get(0);
    }

    public String getLastUnKnowJob() {
        return this.unKnowJobs.get(this.unKnowJobs.size() - 1);
    }

    public String getMatchingUnKnowJob(Predicate<String> predicate) {
        for (String item : this.unKnowJobs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingUnKnowJob(Predicate<String> predicate) {
        for (String item : this.unKnowJobs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withUnKnowJobs(List<String> unKnowJobs) {
        if (unKnowJobs != null) {
            this.unKnowJobs = new ArrayList<String>();
            for (String item : unKnowJobs) {
                this.addToUnKnowJobs(item);
            }
        } else {
            this.unKnowJobs = null;
        }
        return (A)((Object)this);
    }

    public A withUnKnowJobs(String ... unKnowJobs) {
        if (this.unKnowJobs != null) {
            this.unKnowJobs.clear();
            this._visitables.remove((Object)"unKnowJobs");
        }
        if (unKnowJobs != null) {
            for (String item : unKnowJobs) {
                this.addToUnKnowJobs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasUnKnowJobs() {
        return this.unKnowJobs != null && !this.unKnowJobs.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobFlowStatusFluent that = (JobFlowStatusFluent)((Object)o);
        if (!Objects.equals(this.completedJobs, that.completedJobs)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.failedJobs, that.failedJobs)) {
            return false;
        }
        if (!Objects.equals(this.jobStatusList, that.jobStatusList)) {
            return false;
        }
        if (!Objects.equals(this.pendingJobs, that.pendingJobs)) {
            return false;
        }
        if (!Objects.equals(this.runningJobs, that.runningJobs)) {
            return false;
        }
        if (!Objects.equals((Object)this.state, (Object)that.state)) {
            return false;
        }
        if (!Objects.equals(this.terminatedJobs, that.terminatedJobs)) {
            return false;
        }
        if (!Objects.equals(this.unKnowJobs, that.unKnowJobs)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.completedJobs, this.conditions, this.failedJobs, this.jobStatusList, this.pendingJobs, this.runningJobs, this.state, this.terminatedJobs, this.unKnowJobs, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.completedJobs != null && !this.completedJobs.isEmpty()) {
            sb.append("completedJobs:");
            sb.append(String.valueOf(this.completedJobs) + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(String.valueOf(this.conditions) + ",");
        }
        if (this.failedJobs != null && !this.failedJobs.isEmpty()) {
            sb.append("failedJobs:");
            sb.append(String.valueOf(this.failedJobs) + ",");
        }
        if (this.jobStatusList != null && !this.jobStatusList.isEmpty()) {
            sb.append("jobStatusList:");
            sb.append(String.valueOf(this.jobStatusList) + ",");
        }
        if (this.pendingJobs != null && !this.pendingJobs.isEmpty()) {
            sb.append("pendingJobs:");
            sb.append(String.valueOf(this.pendingJobs) + ",");
        }
        if (this.runningJobs != null && !this.runningJobs.isEmpty()) {
            sb.append("runningJobs:");
            sb.append(String.valueOf(this.runningJobs) + ",");
        }
        if (this.state != null) {
            sb.append("state:");
            sb.append(String.valueOf((Object)this.state) + ",");
        }
        if (this.terminatedJobs != null && !this.terminatedJobs.isEmpty()) {
            sb.append("terminatedJobs:");
            sb.append(String.valueOf(this.terminatedJobs) + ",");
        }
        if (this.unKnowJobs != null && !this.unKnowJobs.isEmpty()) {
            sb.append("unKnowJobs:");
            sb.append(String.valueOf(this.unKnowJobs) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class StateNested<N>
    extends StateFluent<StateNested<N>>
    implements Nested<N> {
        StateBuilder builder;

        StateNested(State item) {
            this.builder = new StateBuilder(this, item);
        }

        public N and() {
            return (N)JobFlowStatusFluent.this.withState(this.builder.build());
        }

        public N endState() {
            return this.and();
        }
    }

    public class JobStatusListNested<N>
    extends JobStatusFluent<JobStatusListNested<N>>
    implements Nested<N> {
        JobStatusBuilder builder;
        int index;

        JobStatusListNested(int index, JobStatus item) {
            this.index = index;
            this.builder = new JobStatusBuilder(this, item);
        }

        public N and() {
            return (N)JobFlowStatusFluent.this.setToJobStatusList(this.index, this.builder.build());
        }

        public N endJobStatusList() {
            return this.and();
        }
    }
}

