/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.tekton.v1.TaskBreakpoints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class TaskBreakpointsFluent<A extends TaskBreakpointsFluent<A>>
extends BaseFluent<A> {
    private List<String> beforeSteps = new ArrayList<String>();
    private String onFailure;
    private Map<String, Object> additionalProperties;

    public TaskBreakpointsFluent() {
    }

    public TaskBreakpointsFluent(TaskBreakpoints instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(TaskBreakpoints instance) {
        TaskBreakpoints taskBreakpoints = instance = instance != null ? instance : new TaskBreakpoints();
        if (instance != null) {
            this.withBeforeSteps(instance.getBeforeSteps());
            this.withOnFailure(instance.getOnFailure());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToBeforeSteps(int index, String item) {
        if (this.beforeSteps == null) {
            this.beforeSteps = new ArrayList<String>();
        }
        this.beforeSteps.add(index, item);
        return (A)((Object)this);
    }

    public A setToBeforeSteps(int index, String item) {
        if (this.beforeSteps == null) {
            this.beforeSteps = new ArrayList<String>();
        }
        this.beforeSteps.set(index, item);
        return (A)((Object)this);
    }

    public A addToBeforeSteps(String ... items) {
        if (this.beforeSteps == null) {
            this.beforeSteps = new ArrayList<String>();
        }
        for (String item : items) {
            this.beforeSteps.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToBeforeSteps(Collection<String> items) {
        if (this.beforeSteps == null) {
            this.beforeSteps = new ArrayList<String>();
        }
        for (String item : items) {
            this.beforeSteps.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromBeforeSteps(String ... items) {
        if (this.beforeSteps == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.beforeSteps.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBeforeSteps(Collection<String> items) {
        if (this.beforeSteps == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.beforeSteps.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getBeforeSteps() {
        return this.beforeSteps;
    }

    public String getBeforeStep(int index) {
        return this.beforeSteps.get(index);
    }

    public String getFirstBeforeStep() {
        return this.beforeSteps.get(0);
    }

    public String getLastBeforeStep() {
        return this.beforeSteps.get(this.beforeSteps.size() - 1);
    }

    public String getMatchingBeforeStep(Predicate<String> predicate) {
        for (String item : this.beforeSteps) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingBeforeStep(Predicate<String> predicate) {
        for (String item : this.beforeSteps) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBeforeSteps(List<String> beforeSteps) {
        if (beforeSteps != null) {
            this.beforeSteps = new ArrayList<String>();
            for (String item : beforeSteps) {
                this.addToBeforeSteps(item);
            }
        } else {
            this.beforeSteps = null;
        }
        return (A)((Object)this);
    }

    public A withBeforeSteps(String ... beforeSteps) {
        if (this.beforeSteps != null) {
            this.beforeSteps.clear();
            this._visitables.remove((Object)"beforeSteps");
        }
        if (beforeSteps != null) {
            for (String item : beforeSteps) {
                this.addToBeforeSteps(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasBeforeSteps() {
        return this.beforeSteps != null && !this.beforeSteps.isEmpty();
    }

    public String getOnFailure() {
        return this.onFailure;
    }

    public A withOnFailure(String onFailure) {
        this.onFailure = onFailure;
        return (A)((Object)this);
    }

    public boolean hasOnFailure() {
        return this.onFailure != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskBreakpointsFluent that = (TaskBreakpointsFluent)((Object)o);
        if (!Objects.equals(this.beforeSteps, that.beforeSteps)) {
            return false;
        }
        if (!Objects.equals(this.onFailure, that.onFailure)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.beforeSteps, this.onFailure, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.beforeSteps != null && !this.beforeSteps.isEmpty()) {
            sb.append("beforeSteps:");
            sb.append(this.beforeSteps + ",");
        }
        if (this.onFailure != null) {
            sb.append("onFailure:");
            sb.append(this.onFailure + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

