/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.knative.v1.Condition;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.tekton.pipeline.v1alpha1.PipelineRunStatus;
import io.fabric8.tekton.pipeline.v1alpha1.PipelineRunStatusFluent;
import io.fabric8.tekton.pipeline.v1alpha1.PipelineRunTaskRunStatus;
import io.fabric8.tekton.pipeline.v1alpha1.Results;
import io.fabric8.tekton.pipeline.v1alpha1.ResultsBuilder;
import io.fabric8.tekton.pipeline.v1alpha1.ResultsFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PipelineRunStatusFluentImpl<A extends PipelineRunStatusFluent<A>>
extends BaseFluent<A>
implements PipelineRunStatusFluent<A> {
    private String completionTime;
    private List<Condition> conditions;
    private Long observedGeneration;
    private ResultsBuilder results;
    private String startTime;
    private Map<String, PipelineRunTaskRunStatus> taskRuns;

    public PipelineRunStatusFluentImpl() {
    }

    public PipelineRunStatusFluentImpl(PipelineRunStatus instance) {
        this.withCompletionTime(instance.getCompletionTime());
        this.withConditions(instance.getConditions());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withResults(instance.getResults());
        this.withStartTime(instance.getStartTime());
        this.withTaskRuns(instance.getTaskRuns());
    }

    @Override
    public String getCompletionTime() {
        return this.completionTime;
    }

    @Override
    public A withCompletionTime(String completionTime) {
        this.completionTime = completionTime;
        return (A)this;
    }

    @Override
    public Boolean hasCompletionTime() {
        return this.completionTime != null;
    }

    @Override
    public A withNewCompletionTime(String arg1) {
        return this.withCompletionTime(new String(arg1));
    }

    @Override
    public A withNewCompletionTime(StringBuilder arg1) {
        return this.withCompletionTime(new String(arg1));
    }

    @Override
    public A withNewCompletionTime(StringBuffer arg1) {
        return this.withCompletionTime(new String(arg1));
    }

    @Override
    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(Condition ... items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    @Override
    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    @Override
    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    @Override
    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = new ArrayList<Condition>();
        }
        return (A)this;
    }

    @Override
    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    @Deprecated
    public Results getResults() {
        return this.results != null ? this.results.build() : null;
    }

    @Override
    public Results buildResults() {
        return this.results != null ? this.results.build() : null;
    }

    @Override
    public A withResults(Results results) {
        this._visitables.get((Object)"results").remove(this.results);
        if (results != null) {
            this.results = new ResultsBuilder(results);
            this._visitables.get((Object)"results").add(this.results);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResults() {
        return this.results != null;
    }

    @Override
    public A withNewResults(String type, String url) {
        return this.withResults(new Results(type, url));
    }

    @Override
    public PipelineRunStatusFluent.ResultsNested<A> withNewResults() {
        return new ResultsNestedImpl();
    }

    @Override
    public PipelineRunStatusFluent.ResultsNested<A> withNewResultsLike(Results item) {
        return new ResultsNestedImpl(item);
    }

    @Override
    public PipelineRunStatusFluent.ResultsNested<A> editResults() {
        return this.withNewResultsLike(this.getResults());
    }

    @Override
    public PipelineRunStatusFluent.ResultsNested<A> editOrNewResults() {
        return this.withNewResultsLike(this.getResults() != null ? this.getResults() : new ResultsBuilder().build());
    }

    @Override
    public PipelineRunStatusFluent.ResultsNested<A> editOrNewResultsLike(Results item) {
        return this.withNewResultsLike(this.getResults() != null ? this.getResults() : item);
    }

    @Override
    public String getStartTime() {
        return this.startTime;
    }

    @Override
    public A withStartTime(String startTime) {
        this.startTime = startTime;
        return (A)this;
    }

    @Override
    public Boolean hasStartTime() {
        return this.startTime != null;
    }

    @Override
    public A withNewStartTime(String arg1) {
        return this.withStartTime(new String(arg1));
    }

    @Override
    public A withNewStartTime(StringBuilder arg1) {
        return this.withStartTime(new String(arg1));
    }

    @Override
    public A withNewStartTime(StringBuffer arg1) {
        return this.withStartTime(new String(arg1));
    }

    @Override
    public A addToTaskRuns(String key, PipelineRunTaskRunStatus value) {
        if (this.taskRuns == null && key != null && value != null) {
            this.taskRuns = new LinkedHashMap<String, PipelineRunTaskRunStatus>();
        }
        if (key != null && value != null) {
            this.taskRuns.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToTaskRuns(Map<String, PipelineRunTaskRunStatus> map) {
        if (this.taskRuns == null && map != null) {
            this.taskRuns = new LinkedHashMap<String, PipelineRunTaskRunStatus>();
        }
        if (map != null) {
            this.taskRuns.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromTaskRuns(String key) {
        if (this.taskRuns == null) {
            return (A)this;
        }
        if (key != null && this.taskRuns != null) {
            this.taskRuns.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromTaskRuns(Map<String, PipelineRunTaskRunStatus> map) {
        if (this.taskRuns == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.taskRuns == null) continue;
                this.taskRuns.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, PipelineRunTaskRunStatus> getTaskRuns() {
        return this.taskRuns;
    }

    @Override
    public A withTaskRuns(Map<String, PipelineRunTaskRunStatus> taskRuns) {
        this.taskRuns = taskRuns == null ? new LinkedHashMap<String, PipelineRunTaskRunStatus>() : new LinkedHashMap<String, PipelineRunTaskRunStatus>(taskRuns);
        return (A)this;
    }

    @Override
    public Boolean hasTaskRuns() {
        return this.taskRuns != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PipelineRunStatusFluentImpl that = (PipelineRunStatusFluentImpl)o;
        if (this.completionTime != null ? !this.completionTime.equals(that.completionTime) : that.completionTime != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.observedGeneration != null ? !this.observedGeneration.equals(that.observedGeneration) : that.observedGeneration != null) {
            return false;
        }
        if (this.results != null ? !this.results.equals(that.results) : that.results != null) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) {
            return false;
        }
        return !(this.taskRuns != null ? !this.taskRuns.equals(that.taskRuns) : that.taskRuns != null);
    }

    public class ResultsNestedImpl<N>
    extends ResultsFluentImpl<PipelineRunStatusFluent.ResultsNested<N>>
    implements PipelineRunStatusFluent.ResultsNested<N>,
    Nested<N> {
        private final ResultsBuilder builder;

        ResultsNestedImpl(Results item) {
            this.builder = new ResultsBuilder(this, item);
        }

        ResultsNestedImpl() {
            this.builder = new ResultsBuilder(this);
        }

        @Override
        public N and() {
            return (N)PipelineRunStatusFluentImpl.this.withResults(this.builder.build());
        }

        @Override
        public N endResults() {
            return this.and();
        }
    }
}

