/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.tekton.pipeline.v1alpha1.Task;
import io.fabric8.tekton.pipeline.v1alpha1.TaskFluent;
import io.fabric8.tekton.pipeline.v1alpha1.TaskFluentImpl;
import javax.validation.Validator;

public class TaskBuilder
extends TaskFluentImpl<TaskBuilder>
implements VisitableBuilder<Task, TaskBuilder> {
    TaskFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TaskBuilder() {
        this(true);
    }

    public TaskBuilder(Boolean validationEnabled) {
        this(new Task(), validationEnabled);
    }

    public TaskBuilder(TaskFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public TaskBuilder(TaskFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Task(), validationEnabled);
    }

    public TaskBuilder(TaskFluent<?> fluent, Task instance) {
        this(fluent, instance, true);
    }

    public TaskBuilder(TaskFluent<?> fluent, Task instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public TaskBuilder(Task instance) {
        this(instance, (Boolean)true);
    }

    public TaskBuilder(Task instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public TaskBuilder(Validator validator) {
        this(new Task(), (Boolean)true);
    }

    public TaskBuilder(TaskFluent<?> fluent, Task instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public TaskBuilder(Task instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public Task build() {
        Task buildable = new Task(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable, (Validator)this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskBuilder that = (TaskBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

