/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.client;

import io.fabric8.kubernetes.client.BaseClient;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.RequestConfig;
import io.fabric8.kubernetes.client.WithRequestCallable;
import io.fabric8.kubernetes.client.dsl.FunctionCallable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.tekton.client.NamespacedTektonClient;
import io.fabric8.tekton.client.internal.ClusterTaskOperationsImpl;
import io.fabric8.tekton.client.internal.PipelineOperationsImpl;
import io.fabric8.tekton.client.internal.PipelineResourceOperationsImpl;
import io.fabric8.tekton.client.internal.PipelineRunOperationsImpl;
import io.fabric8.tekton.client.internal.TaskOperationsImpl;
import io.fabric8.tekton.client.internal.TaskRunOperationsImpl;
import io.fabric8.tekton.pipeline.v1alpha1.ClusterTask;
import io.fabric8.tekton.pipeline.v1alpha1.ClusterTaskList;
import io.fabric8.tekton.pipeline.v1alpha1.DoneableClusterTask;
import io.fabric8.tekton.pipeline.v1alpha1.DoneablePipeline;
import io.fabric8.tekton.pipeline.v1alpha1.DoneablePipelineResource;
import io.fabric8.tekton.pipeline.v1alpha1.DoneablePipelineRun;
import io.fabric8.tekton.pipeline.v1alpha1.DoneableTask;
import io.fabric8.tekton.pipeline.v1alpha1.DoneableTaskRun;
import io.fabric8.tekton.pipeline.v1alpha1.Pipeline;
import io.fabric8.tekton.pipeline.v1alpha1.PipelineList;
import io.fabric8.tekton.pipeline.v1alpha1.PipelineResource;
import io.fabric8.tekton.pipeline.v1alpha1.PipelineResourceList;
import io.fabric8.tekton.pipeline.v1alpha1.PipelineRun;
import io.fabric8.tekton.pipeline.v1alpha1.PipelineRunList;
import io.fabric8.tekton.pipeline.v1alpha1.Task;
import io.fabric8.tekton.pipeline.v1alpha1.TaskList;
import io.fabric8.tekton.pipeline.v1alpha1.TaskRun;
import io.fabric8.tekton.pipeline.v1alpha1.TaskRunList;
import okhttp3.OkHttpClient;

public class DefaultTektonClient
extends BaseClient
implements NamespacedTektonClient {
    public DefaultTektonClient() {
    }

    public DefaultTektonClient(Config configuration) {
        super(configuration);
    }

    public DefaultTektonClient(OkHttpClient httpClient, Config configuration) {
        super(httpClient, configuration);
    }

    public NamespacedTektonClient inAnyNamespace() {
        return this.inNamespace(null);
    }

    public NamespacedTektonClient inNamespace(String namespace) {
        Config updated = ((ConfigBuilder)new ConfigBuilder(this.getConfiguration()).withNamespace(namespace)).build();
        return new DefaultTektonClient(this.getHttpClient(), updated);
    }

    public FunctionCallable<NamespacedTektonClient> withRequestConfig(RequestConfig requestConfig) {
        return new WithRequestCallable((Client)this, requestConfig);
    }

    @Override
    public MixedOperation<Pipeline, PipelineList, DoneablePipeline, Resource<Pipeline, DoneablePipeline>> pipelines() {
        return new PipelineOperationsImpl(this.getHttpClient(), this.getConfiguration());
    }

    @Override
    public MixedOperation<PipelineRun, PipelineRunList, DoneablePipelineRun, Resource<PipelineRun, DoneablePipelineRun>> pipelineRuns() {
        return new PipelineRunOperationsImpl(this.getHttpClient(), this.getConfiguration());
    }

    @Override
    public MixedOperation<PipelineResource, PipelineResourceList, DoneablePipelineResource, Resource<PipelineResource, DoneablePipelineResource>> pipelineResources() {
        return new PipelineResourceOperationsImpl(this.getHttpClient(), this.getConfiguration());
    }

    @Override
    public MixedOperation<Task, TaskList, DoneableTask, Resource<Task, DoneableTask>> tasks() {
        return new TaskOperationsImpl(this.getHttpClient(), this.getConfiguration());
    }

    @Override
    public MixedOperation<TaskRun, TaskRunList, DoneableTaskRun, Resource<TaskRun, DoneableTaskRun>> taskRuns() {
        return new TaskRunOperationsImpl(this.getHttpClient(), this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<ClusterTask, ClusterTaskList, DoneableClusterTask, Resource<ClusterTask, DoneableClusterTask>> clusterTasks() {
        return new ClusterTaskOperationsImpl(this.getHttpClient(), this.getConfiguration());
    }
}

