/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.taiga;

import io.fabric8.taiga.AuthDTO;
import io.fabric8.taiga.AuthDetailDTO;
import io.fabric8.taiga.ModuleDTO;
import io.fabric8.taiga.ProjectDTO;
import io.fabric8.taiga.Projects;
import io.fabric8.taiga.TaigaApi;
import io.fabric8.taiga.TaigaModule;
import io.fabric8.taiga.UserDTO;
import io.fabric8.utils.Strings;
import io.fabric8.utils.URLUtils;
import io.fabric8.utils.jaxrs.JAXRSClients;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public abstract class TaigaClientSupport {
    protected final String address;
    protected final String username;
    protected final String password;
    private TaigaApi api;
    private AuthDetailDTO authentication;
    private boolean autoCreateProjects = true;

    public TaigaClientSupport(String address, String username, String password) {
        this.address = address;
        this.password = password;
        this.username = username;
    }

    public Long getProjectIdForSlug(String slug) {
        ProjectDTO project = this.getProjectBySlug(slug);
        return project != null ? project.getId() : null;
    }

    public ProjectDTO getOrCreateProject(String name) {
        return this.getOrCreateProject(name, null);
    }

    public ProjectDTO getOrCreateProject(String name, String slugOrNull) {
        String slug = this.validateSlug(slugOrNull, name);
        ProjectDTO project = this.getProjectBySlug(slug);
        if (project == null) {
            project = new ProjectDTO();
            project.setSlug(slug);
            project.setName(name);
            project.setDescription("Description of project " + name);
            Projects.addUser(project, this.getMe());
            return this.createProject(project);
        }
        return project;
    }

    public ModuleDTO moduleForProject(String slug, TaigaModule module) {
        return this.moduleForProject(slug, module.toModuleKey());
    }

    public ModuleDTO moduleForProject(String slug, String module) {
        Map<String, ModuleDTO> map = this.getModulesForProject(slug);
        return map.get(module);
    }

    public ModuleDTO moduleForProject(Long projectId, TaigaModule module) {
        return this.moduleForProject(projectId, module.toModuleKey());
    }

    public ModuleDTO moduleForProject(Long projectId, String module) {
        Map<String, ModuleDTO> map = this.getModulesForProject(projectId);
        return map.get(module);
    }

    public String getPublicWebhookUrl(ModuleDTO module) {
        if (module != null) {
            int idx;
            String webhooksUrl = module.getWebhooksUrl();
            if (Strings.isNotBlank((String)webhooksUrl) && (idx = webhooksUrl.indexOf("/api/v")) > 0) {
                return URLUtils.pathJoin((String[])new String[]{this.getAddress(), webhooksUrl.substring(idx)});
            }
            return webhooksUrl;
        }
        return null;
    }

    public ProjectDTO createProject(ProjectDTO dto) {
        return this.getApi().createProject(dto);
    }

    public List<ProjectDTO> getProjects() {
        return this.getApi().getProjects();
    }

    public ProjectDTO getProjectById(final String id) {
        return (ProjectDTO)JAXRSClients.handle404ByReturningNull((Callable)new Callable<ProjectDTO>(){

            @Override
            public ProjectDTO call() throws Exception {
                return TaigaClientSupport.this.getApi().getProjectById(id);
            }
        });
    }

    public ProjectDTO getProjectBySlug(final String slug) {
        return (ProjectDTO)JAXRSClients.handle404ByReturningNull((Callable)new Callable<ProjectDTO>(){

            @Override
            public ProjectDTO call() throws Exception {
                return TaigaClientSupport.this.getApi().getProjectBySlug(slug);
            }
        });
    }

    public UserDTO getMe() {
        return (UserDTO)JAXRSClients.handle404ByReturningNull((Callable)new Callable<UserDTO>(){

            @Override
            public UserDTO call() throws Exception {
                return TaigaClientSupport.this.getApi().getMe();
            }
        });
    }

    public UserDTO getUser(final String id) {
        return (UserDTO)JAXRSClients.handle404ByReturningNull((Callable)new Callable<UserDTO>(){

            @Override
            public UserDTO call() throws Exception {
                return TaigaClientSupport.this.getApi().getUser(id);
            }
        });
    }

    public Map<String, ModuleDTO> getModulesForProject(String slug) {
        Long id = this.getProjectIdForSlug(slug);
        if (id != null) {
            return this.getModulesForProject(id);
        }
        return new HashMap<String, ModuleDTO>();
    }

    public Map<String, ModuleDTO> getModulesForProject(final Long id) {
        HashMap answer = (HashMap)JAXRSClients.handle404ByReturningNull((Callable)new Callable<Map<String, ModuleDTO>>(){

            @Override
            public Map<String, ModuleDTO> call() throws Exception {
                return TaigaClientSupport.this.getApi().getModulesForProject(id);
            }
        });
        if (answer == null) {
            answer = new HashMap();
        }
        return answer;
    }

    public String getAddress() {
        return this.address;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAutoCreateProjects() {
        return this.autoCreateProjects;
    }

    public void setAutoCreateProjects(boolean autoCreateProjects) {
        this.autoCreateProjects = autoCreateProjects;
    }

    protected abstract <T> T createWebClient(Class<T> var1);

    protected TaigaApi getApi() {
        if (this.api == null) {
            this.api = this.createWebClient(TaigaApi.class);
            this.doAuthentication(this.api);
        }
        return this.api;
    }

    protected void doAuthentication(TaigaApi api) {
        AuthDTO authDto = new AuthDTO();
        authDto.setUsername(this.username);
        authDto.setPassword(this.password);
        this.authentication = this.getApi().authenticate(authDto);
    }

    protected String getAuthToken() {
        if (this.authentication != null) {
            return this.authentication.getAuthToken();
        }
        return null;
    }

    protected String validateSlug(String slug, String name) {
        if (Strings.isNotBlank((String)slug)) {
            return slug;
        }
        return this.getUsername() + "-" + name;
    }
}

