/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.taiga;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.taiga.TaigaClient;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaigaKubernetes {
    private static final transient Logger LOG = LoggerFactory.getLogger(TaigaKubernetes.class);

    public static TaigaClient createTaiga(KubernetesClient kubernetes, String namespace) {
        String userName = Systems.getEnvVarOrSystemProperty((String)"TAIGA_USERNAME", (String)"admin");
        String password = Systems.getEnvVarOrSystemProperty((String)"TAIGA_PASSWORD", (String)"123123");
        String address = null;
        try {
            address = KubernetesHelper.getServiceURL((KubernetesClient)kubernetes, (String)"taiga", (String)namespace, (String)"http", (boolean)true);
            if (Strings.isNullOrBlank((String)address)) {
                LOG.warn("No Taiga service could be found in kubernetes " + namespace + " on address: " + kubernetes.getMasterUrl());
                return null;
            }
        }
        catch (IllegalArgumentException e) {
            LOG.warn("No Taiga service could be found in kubernetes " + namespace + " on address: " + kubernetes.getMasterUrl());
            return null;
        }
        LOG.info("Logging into Taiga at " + address + " as user " + userName);
        return new TaigaClient(address, userName, password);
    }
}

