/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.swagger.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.swagger.model.Authorizations;
import io.fabric8.swagger.model.Parameter;
import io.fabric8.swagger.model.ResponseMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"method", "summary", "notes", "nickname", "authorizations", "parameters", "responseMessages", "produces", "consumes", "deprecated"})
public class Operation {
    @JsonProperty(value="method")
    private Method method;
    @JsonProperty(value="summary")
    @Size(max=120)
    private String summary;
    @JsonProperty(value="notes")
    private String notes;
    @JsonProperty(value="nickname")
    @Pattern(regexp="^[a-zA-Z0-9_]+$")
    private String nickname;
    @JsonProperty(value="authorizations")
    @Valid
    private Authorizations authorizations;
    @JsonProperty(value="parameters")
    @Valid
    private List<Parameter> parameters = new ArrayList<Parameter>();
    @JsonProperty(value="responseMessages")
    @Valid
    private List<ResponseMessage> responseMessages = new ArrayList<ResponseMessage>();
    @JsonProperty(value="produces")
    @JsonDeserialize(as=LinkedHashSet.class)
    @Valid
    private Set<String> produces = new LinkedHashSet<String>();
    @JsonProperty(value="consumes")
    @JsonDeserialize(as=LinkedHashSet.class)
    @Valid
    private Set<String> consumes = new LinkedHashSet<String>();
    @JsonProperty(value="deprecated")
    private Deprecated deprecated;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="method")
    public Method getMethod() {
        return this.method;
    }

    @JsonProperty(value="method")
    public void setMethod(Method method) {
        this.method = method;
    }

    @JsonProperty(value="summary")
    public String getSummary() {
        return this.summary;
    }

    @JsonProperty(value="summary")
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @JsonProperty(value="notes")
    public String getNotes() {
        return this.notes;
    }

    @JsonProperty(value="notes")
    public void setNotes(String notes) {
        this.notes = notes;
    }

    @JsonProperty(value="nickname")
    public String getNickname() {
        return this.nickname;
    }

    @JsonProperty(value="nickname")
    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    @JsonProperty(value="authorizations")
    public Authorizations getAuthorizations() {
        return this.authorizations;
    }

    @JsonProperty(value="authorizations")
    public void setAuthorizations(Authorizations authorizations) {
        this.authorizations = authorizations;
    }

    @JsonProperty(value="parameters")
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @JsonProperty(value="parameters")
    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    @JsonProperty(value="responseMessages")
    public List<ResponseMessage> getResponseMessages() {
        return this.responseMessages;
    }

    @JsonProperty(value="responseMessages")
    public void setResponseMessages(List<ResponseMessage> responseMessages) {
        this.responseMessages = responseMessages;
    }

    @JsonProperty(value="produces")
    public Set<String> getProduces() {
        return this.produces;
    }

    @JsonProperty(value="produces")
    public void setProduces(Set<String> produces) {
        this.produces = produces;
    }

    @JsonProperty(value="consumes")
    public Set<String> getConsumes() {
        return this.consumes;
    }

    @JsonProperty(value="consumes")
    public void setConsumes(Set<String> consumes) {
        this.consumes = consumes;
    }

    @JsonProperty(value="deprecated")
    public Deprecated getDeprecated() {
        return this.deprecated;
    }

    @JsonProperty(value="deprecated")
    public void setDeprecated(Deprecated deprecated) {
        this.deprecated = deprecated;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "Operation(method=" + (Object)((Object)this.getMethod()) + ", summary=" + this.getSummary() + ", notes=" + this.getNotes() + ", nickname=" + this.getNickname() + ", authorizations=" + this.getAuthorizations() + ", parameters=" + this.getParameters() + ", responseMessages=" + this.getResponseMessages() + ", produces=" + this.getProduces() + ", consumes=" + this.getConsumes() + ", deprecated=" + (Object)((Object)this.getDeprecated()) + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Operation)) {
            return false;
        }
        Operation other = (Operation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Method this$method = this.getMethod();
        Method other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        String this$summary = this.getSummary();
        String other$summary = other.getSummary();
        if (this$summary == null ? other$summary != null : !this$summary.equals(other$summary)) {
            return false;
        }
        String this$notes = this.getNotes();
        String other$notes = other.getNotes();
        if (this$notes == null ? other$notes != null : !this$notes.equals(other$notes)) {
            return false;
        }
        String this$nickname = this.getNickname();
        String other$nickname = other.getNickname();
        if (this$nickname == null ? other$nickname != null : !this$nickname.equals(other$nickname)) {
            return false;
        }
        Authorizations this$authorizations = this.getAuthorizations();
        Authorizations other$authorizations = other.getAuthorizations();
        if (this$authorizations == null ? other$authorizations != null : !((Object)this$authorizations).equals(other$authorizations)) {
            return false;
        }
        List<Parameter> this$parameters = this.getParameters();
        List<Parameter> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        List<ResponseMessage> this$responseMessages = this.getResponseMessages();
        List<ResponseMessage> other$responseMessages = other.getResponseMessages();
        if (this$responseMessages == null ? other$responseMessages != null : !((Object)this$responseMessages).equals(other$responseMessages)) {
            return false;
        }
        Set<String> this$produces = this.getProduces();
        Set<String> other$produces = other.getProduces();
        if (this$produces == null ? other$produces != null : !((Object)this$produces).equals(other$produces)) {
            return false;
        }
        Set<String> this$consumes = this.getConsumes();
        Set<String> other$consumes = other.getConsumes();
        if (this$consumes == null ? other$consumes != null : !((Object)this$consumes).equals(other$consumes)) {
            return false;
        }
        Deprecated this$deprecated = this.getDeprecated();
        Deprecated other$deprecated = other.getDeprecated();
        if (this$deprecated == null ? other$deprecated != null : !((Object)((Object)this$deprecated)).equals((Object)other$deprecated)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Operation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Method $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        String $summary = this.getSummary();
        result = result * 59 + ($summary == null ? 43 : $summary.hashCode());
        String $notes = this.getNotes();
        result = result * 59 + ($notes == null ? 43 : $notes.hashCode());
        String $nickname = this.getNickname();
        result = result * 59 + ($nickname == null ? 43 : $nickname.hashCode());
        Authorizations $authorizations = this.getAuthorizations();
        result = result * 59 + ($authorizations == null ? 43 : ((Object)$authorizations).hashCode());
        List<Parameter> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        List<ResponseMessage> $responseMessages = this.getResponseMessages();
        result = result * 59 + ($responseMessages == null ? 43 : ((Object)$responseMessages).hashCode());
        Set<String> $produces = this.getProduces();
        result = result * 59 + ($produces == null ? 43 : ((Object)$produces).hashCode());
        Set<String> $consumes = this.getConsumes();
        result = result * 59 + ($consumes == null ? 43 : ((Object)$consumes).hashCode());
        Deprecated $deprecated = this.getDeprecated();
        result = result * 59 + ($deprecated == null ? 43 : ((Object)((Object)$deprecated)).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public static enum Method {
        GET("GET"),
        HEAD("HEAD"),
        POST("POST"),
        PUT("PUT"),
        PATCH("PATCH"),
        DELETE("DELETE"),
        OPTIONS("OPTIONS");

        private final String value;
        private static final Map<String, Method> CONSTANTS;

        private Method(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Method fromValue(String value) {
            Method constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Method>();
            for (Method c : Method.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum Deprecated {
        TRUE("true"),
        FALSE("false");

        private final String value;
        private static final Map<String, Deprecated> CONSTANTS;

        private Deprecated(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Deprecated fromValue(String value) {
            Deprecated constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Deprecated>();
            for (Deprecated c : Deprecated.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

