/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.servicecatalog.api.model.ServiceClassSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ServiceClassSpecFluent<A extends ServiceClassSpecFluent<A>>
extends BaseFluent<A> {
    private Boolean bindable;
    private Boolean bindingRetrievable;
    private Map<String, Object> defaultProvisionParameters;
    private String description;
    private String externalID;
    private Map<String, Object> externalMetadata;
    private String externalName;
    private Boolean planUpdatable;
    private List<String> requires = new ArrayList<String>();
    private String serviceBrokerName;
    private List<String> tags = new ArrayList<String>();

    public ServiceClassSpecFluent() {
    }

    public ServiceClassSpecFluent(ServiceClassSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ServiceClassSpec instance) {
        ServiceClassSpec serviceClassSpec = instance = instance != null ? instance : new ServiceClassSpec();
        if (instance != null) {
            this.withBindable(instance.getBindable());
            this.withBindingRetrievable(instance.getBindingRetrievable());
            this.withDefaultProvisionParameters(instance.getDefaultProvisionParameters());
            this.withDescription(instance.getDescription());
            this.withExternalID(instance.getExternalID());
            this.withExternalMetadata(instance.getExternalMetadata());
            this.withExternalName(instance.getExternalName());
            this.withPlanUpdatable(instance.getPlanUpdatable());
            this.withRequires(instance.getRequires());
            this.withServiceBrokerName(instance.getServiceBrokerName());
            this.withTags(instance.getTags());
            this.withBindable(instance.getBindable());
            this.withBindingRetrievable(instance.getBindingRetrievable());
            this.withDefaultProvisionParameters(instance.getDefaultProvisionParameters());
            this.withDescription(instance.getDescription());
            this.withExternalID(instance.getExternalID());
            this.withExternalMetadata(instance.getExternalMetadata());
            this.withExternalName(instance.getExternalName());
            this.withPlanUpdatable(instance.getPlanUpdatable());
            this.withRequires(instance.getRequires());
            this.withServiceBrokerName(instance.getServiceBrokerName());
            this.withTags(instance.getTags());
        }
    }

    public Boolean getBindable() {
        return this.bindable;
    }

    public A withBindable(Boolean bindable) {
        this.bindable = bindable;
        return (A)((Object)this);
    }

    public boolean hasBindable() {
        return this.bindable != null;
    }

    public Boolean getBindingRetrievable() {
        return this.bindingRetrievable;
    }

    public A withBindingRetrievable(Boolean bindingRetrievable) {
        this.bindingRetrievable = bindingRetrievable;
        return (A)((Object)this);
    }

    public boolean hasBindingRetrievable() {
        return this.bindingRetrievable != null;
    }

    public A addToDefaultProvisionParameters(String key, Object value) {
        if (this.defaultProvisionParameters == null && key != null && value != null) {
            this.defaultProvisionParameters = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.defaultProvisionParameters.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToDefaultProvisionParameters(Map<String, Object> map) {
        if (this.defaultProvisionParameters == null && map != null) {
            this.defaultProvisionParameters = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.defaultProvisionParameters.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromDefaultProvisionParameters(String key) {
        if (this.defaultProvisionParameters == null) {
            return (A)((Object)this);
        }
        if (key != null && this.defaultProvisionParameters != null) {
            this.defaultProvisionParameters.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromDefaultProvisionParameters(Map<String, Object> map) {
        if (this.defaultProvisionParameters == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.defaultProvisionParameters == null) continue;
                this.defaultProvisionParameters.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getDefaultProvisionParameters() {
        return this.defaultProvisionParameters;
    }

    public <K, V> A withDefaultProvisionParameters(Map<String, Object> defaultProvisionParameters) {
        this.defaultProvisionParameters = defaultProvisionParameters == null ? null : new LinkedHashMap<String, Object>(defaultProvisionParameters);
        return (A)((Object)this);
    }

    public boolean hasDefaultProvisionParameters() {
        return this.defaultProvisionParameters != null;
    }

    public String getDescription() {
        return this.description;
    }

    public A withDescription(String description) {
        this.description = description;
        return (A)((Object)this);
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public String getExternalID() {
        return this.externalID;
    }

    public A withExternalID(String externalID) {
        this.externalID = externalID;
        return (A)((Object)this);
    }

    public boolean hasExternalID() {
        return this.externalID != null;
    }

    public A addToExternalMetadata(String key, Object value) {
        if (this.externalMetadata == null && key != null && value != null) {
            this.externalMetadata = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.externalMetadata.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToExternalMetadata(Map<String, Object> map) {
        if (this.externalMetadata == null && map != null) {
            this.externalMetadata = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.externalMetadata.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromExternalMetadata(String key) {
        if (this.externalMetadata == null) {
            return (A)((Object)this);
        }
        if (key != null && this.externalMetadata != null) {
            this.externalMetadata.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromExternalMetadata(Map<String, Object> map) {
        if (this.externalMetadata == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.externalMetadata == null) continue;
                this.externalMetadata.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getExternalMetadata() {
        return this.externalMetadata;
    }

    public <K, V> A withExternalMetadata(Map<String, Object> externalMetadata) {
        this.externalMetadata = externalMetadata == null ? null : new LinkedHashMap<String, Object>(externalMetadata);
        return (A)((Object)this);
    }

    public boolean hasExternalMetadata() {
        return this.externalMetadata != null;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public A withExternalName(String externalName) {
        this.externalName = externalName;
        return (A)((Object)this);
    }

    public boolean hasExternalName() {
        return this.externalName != null;
    }

    public Boolean getPlanUpdatable() {
        return this.planUpdatable;
    }

    public A withPlanUpdatable(Boolean planUpdatable) {
        this.planUpdatable = planUpdatable;
        return (A)((Object)this);
    }

    public boolean hasPlanUpdatable() {
        return this.planUpdatable != null;
    }

    public A addToRequires(int index, String item) {
        if (this.requires == null) {
            this.requires = new ArrayList<String>();
        }
        this.requires.add(index, item);
        return (A)((Object)this);
    }

    public A setToRequires(int index, String item) {
        if (this.requires == null) {
            this.requires = new ArrayList<String>();
        }
        this.requires.set(index, item);
        return (A)((Object)this);
    }

    public A addToRequires(String ... items) {
        if (this.requires == null) {
            this.requires = new ArrayList<String>();
        }
        for (String item : items) {
            this.requires.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToRequires(Collection<String> items) {
        if (this.requires == null) {
            this.requires = new ArrayList<String>();
        }
        for (String item : items) {
            this.requires.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromRequires(String ... items) {
        if (this.requires == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.requires.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRequires(Collection<String> items) {
        if (this.requires == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.requires.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getRequires() {
        return this.requires;
    }

    public String getRequire(int index) {
        return this.requires.get(index);
    }

    public String getFirstRequire() {
        return this.requires.get(0);
    }

    public String getLastRequire() {
        return this.requires.get(this.requires.size() - 1);
    }

    public String getMatchingRequire(Predicate<String> predicate) {
        for (String item : this.requires) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingRequire(Predicate<String> predicate) {
        for (String item : this.requires) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRequires(List<String> requires) {
        if (requires != null) {
            this.requires = new ArrayList<String>();
            for (String item : requires) {
                this.addToRequires(item);
            }
        } else {
            this.requires = null;
        }
        return (A)((Object)this);
    }

    public A withRequires(String ... requires) {
        if (this.requires != null) {
            this.requires.clear();
            this._visitables.remove((Object)"requires");
        }
        if (requires != null) {
            for (String item : requires) {
                this.addToRequires(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRequires() {
        return this.requires != null && !this.requires.isEmpty();
    }

    public String getServiceBrokerName() {
        return this.serviceBrokerName;
    }

    public A withServiceBrokerName(String serviceBrokerName) {
        this.serviceBrokerName = serviceBrokerName;
        return (A)((Object)this);
    }

    public boolean hasServiceBrokerName() {
        return this.serviceBrokerName != null;
    }

    public A addToTags(int index, String item) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(index, item);
        return (A)((Object)this);
    }

    public A setToTags(int index, String item) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.set(index, item);
        return (A)((Object)this);
    }

    public A addToTags(String ... items) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        for (String item : items) {
            this.tags.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTags(Collection<String> items) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        for (String item : items) {
            this.tags.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTags(String ... items) {
        if (this.tags == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tags.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTags(Collection<String> items) {
        if (this.tags == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tags.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getTag(int index) {
        return this.tags.get(index);
    }

    public String getFirstTag() {
        return this.tags.get(0);
    }

    public String getLastTag() {
        return this.tags.get(this.tags.size() - 1);
    }

    public String getMatchingTag(Predicate<String> predicate) {
        for (String item : this.tags) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTag(Predicate<String> predicate) {
        for (String item : this.tags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTags(List<String> tags) {
        if (tags != null) {
            this.tags = new ArrayList<String>();
            for (String item : tags) {
                this.addToTags(item);
            }
        } else {
            this.tags = null;
        }
        return (A)((Object)this);
    }

    public A withTags(String ... tags) {
        if (this.tags != null) {
            this.tags.clear();
            this._visitables.remove((Object)"tags");
        }
        if (tags != null) {
            for (String item : tags) {
                this.addToTags(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceClassSpecFluent that = (ServiceClassSpecFluent)((Object)o);
        if (!Objects.equals(this.bindable, that.bindable)) {
            return false;
        }
        if (!Objects.equals(this.bindingRetrievable, that.bindingRetrievable)) {
            return false;
        }
        if (!Objects.equals(this.defaultProvisionParameters, that.defaultProvisionParameters)) {
            return false;
        }
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.externalID, that.externalID)) {
            return false;
        }
        if (!Objects.equals(this.externalMetadata, that.externalMetadata)) {
            return false;
        }
        if (!Objects.equals(this.externalName, that.externalName)) {
            return false;
        }
        if (!Objects.equals(this.planUpdatable, that.planUpdatable)) {
            return false;
        }
        if (!Objects.equals(this.requires, that.requires)) {
            return false;
        }
        if (!Objects.equals(this.serviceBrokerName, that.serviceBrokerName)) {
            return false;
        }
        return Objects.equals(this.tags, that.tags);
    }

    public int hashCode() {
        return Objects.hash(this.bindable, this.bindingRetrievable, this.defaultProvisionParameters, this.description, this.externalID, this.externalMetadata, this.externalName, this.planUpdatable, this.requires, this.serviceBrokerName, this.tags, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bindable != null) {
            sb.append("bindable:");
            sb.append(this.bindable + ",");
        }
        if (this.bindingRetrievable != null) {
            sb.append("bindingRetrievable:");
            sb.append(this.bindingRetrievable + ",");
        }
        if (this.defaultProvisionParameters != null && !this.defaultProvisionParameters.isEmpty()) {
            sb.append("defaultProvisionParameters:");
            sb.append(this.defaultProvisionParameters + ",");
        }
        if (this.description != null) {
            sb.append("description:");
            sb.append(this.description + ",");
        }
        if (this.externalID != null) {
            sb.append("externalID:");
            sb.append(this.externalID + ",");
        }
        if (this.externalMetadata != null && !this.externalMetadata.isEmpty()) {
            sb.append("externalMetadata:");
            sb.append(this.externalMetadata + ",");
        }
        if (this.externalName != null) {
            sb.append("externalName:");
            sb.append(this.externalName + ",");
        }
        if (this.planUpdatable != null) {
            sb.append("planUpdatable:");
            sb.append(this.planUpdatable + ",");
        }
        if (this.requires != null && !this.requires.isEmpty()) {
            sb.append("requires:");
            sb.append(this.requires + ",");
        }
        if (this.serviceBrokerName != null) {
            sb.append("serviceBrokerName:");
            sb.append(this.serviceBrokerName + ",");
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            sb.append("tags:");
            sb.append(this.tags);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withBindable() {
        return this.withBindable(true);
    }

    public A withBindingRetrievable() {
        return this.withBindingRetrievable(true);
    }

    public A withPlanUpdatable() {
        return this.withPlanUpdatable(true);
    }
}

