/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.runtime.embedded.registration;

import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.jboss.gravia.runtime.Runtime;
import org.osgi.service.component.ComponentContext;

@ThreadSafe
@Component(label="Embedded Runtime Properties Service", immediate=true, metatype=false)
@Service(value={RuntimeProperties.class})
public class EmbeddedPropertiesService
extends AbstractComponent
implements RuntimeProperties {
    @Reference(referenceInterface=Runtime.class)
    private ValidatingReference<Runtime> runtime = new ValidatingReference();
    private String identity;
    private Path homePath;
    private Path dataPath;
    private Path confPath;

    @Activate
    void activate(ComponentContext componentContext) throws Exception {
        this.identity = this.getRequiredProperty("runtime.id");
        this.homePath = Paths.get(this.getRequiredProperty("runtime.home"), new String[0]);
        this.dataPath = Paths.get(this.getRequiredProperty("runtime.data"), new String[0]);
        this.confPath = Paths.get(this.getRequiredProperty("runtime.conf"), new String[0]);
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public String getRuntimeIdentity() {
        return this.identity;
    }

    public Path getHomePath() {
        return this.homePath;
    }

    public Path getConfPath() {
        return this.confPath;
    }

    public Path getDataPath() {
        return this.dataPath;
    }

    public String getProperty(String key) {
        return this.getPropertyInternal(key, null);
    }

    public String getProperty(String key, String defaultValue) {
        return this.getPropertyInternal(key, defaultValue);
    }

    private String getPropertyInternal(String key, String defaultValue) {
        return (String)((Runtime)this.runtime.get()).getProperty(key, (Object)defaultValue);
    }

    private String getRequiredProperty(String propName) {
        String result = this.getPropertyInternal(propName, null);
        if (result != null) {
            return result;
        }
        throw new IllegalStateException("Cannot obtain required property: " + propName);
    }

    void bindRuntime(Runtime service) {
        this.runtime.bind((Object)service);
    }

    void unbindRuntime(Runtime service) {
        this.runtime.unbind((Object)service);
    }
}

