/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.fabric.service;

import io.fabric8.api.ZooKeeperClusterBootstrap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.jar.Manifest;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.ServiceEvent;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.gravia.runtime.spi.AbstractModule;
import org.jboss.gravia.runtime.spi.ClassLoaderEntriesProvider;
import org.jboss.gravia.runtime.spi.ManifestHeadersProvider;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extension.fabric.FabricConstants;
import org.wildfly.extension.gravia.GraviaConstants;

public class FabricBootstrapService
extends AbstractService<ZooKeeperClusterBootstrap> {
    static final Logger LOGGER = LoggerFactory.getLogger((String)FabricConstants.class.getPackage().getName());
    private final InjectedValue<ModuleContext> injectedModuleContext = new InjectedValue();
    private final InjectedValue<Runtime> injectedRuntime = new InjectedValue();
    private ZooKeeperClusterBootstrap bootstrapService;
    private Module module;

    public ServiceController<ZooKeeperClusterBootstrap> install(ServiceTarget serviceTarget, ServiceVerificationHandler verificationHandler) {
        ServiceBuilder builder = serviceTarget.addService(FabricConstants.FABRIC_SUBSYSTEM_SERVICE_NAME, (Service)this);
        builder.addDependency(GraviaConstants.MODULE_CONTEXT_SERVICE_NAME, ModuleContext.class, this.injectedModuleContext);
        builder.addDependency(GraviaConstants.RUNTIME_SERVICE_NAME, Runtime.class, this.injectedRuntime);
        builder.addListener((ServiceListener)verificationHandler);
        return builder.install();
    }

    public void start(StartContext startContext) throws StartException {
        LOGGER.info("Activating Fabric Subsystem");
        Runtime runtime = (Runtime)this.injectedRuntime.getValue();
        this.initConfigurationAdmin(runtime);
        final CountDownLatch latch = new CountDownLatch(1);
        final ModuleContext syscontext = (ModuleContext)this.injectedModuleContext.getValue();
        org.jboss.gravia.runtime.ServiceListener listener = new org.jboss.gravia.runtime.ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                if (event.getType() == 1) {
                    ServiceReference sref = event.getServiceReference();
                    FabricBootstrapService.this.bootstrapService = (ZooKeeperClusterBootstrap)syscontext.getService(sref);
                    syscontext.removeServiceListener((org.jboss.gravia.runtime.ServiceListener)this);
                    latch.countDown();
                }
            }
        };
        syscontext.addServiceListener(listener, "(objectClass=" + ZooKeeperClusterBootstrap.class.getName() + ")");
        ModuleClassLoader classLoader = (ModuleClassLoader)((Object)((Object)this)).getClass().getClassLoader();
        try {
            URL url = classLoader.getResource("META-INF/MANIFEST.MF");
            Manifest manifest = new Manifest(url.openStream());
            Dictionary headers = new ManifestHeadersProvider(manifest).getHeaders();
            this.module = runtime.installModule((ClassLoader)classLoader, headers);
            ClassLoaderEntriesProvider entriesProvider = new ClassLoaderEntriesProvider(this.module);
            AbstractModule attachable = AbstractModule.assertAbstractModule((Module)this.module);
            attachable.putAttachment(AbstractModule.MODULE_ENTRIES_PROVIDER_KEY, (Object)entriesProvider);
            this.module.start();
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new StartException((Throwable)ex);
        }
        try {
            if (!latch.await(5L, TimeUnit.SECONDS)) {
                throw new StartException("Cannot obtain ZooKeeperClusterBootstrap");
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        Properties brandingProperties = new Properties();
        String resname = "/META-INF/branding.properties";
        try {
            URL brandingURL = ((Object)((Object)this)).getClass().getResource(resname);
            brandingProperties.load(brandingURL.openStream());
        }
        catch (IOException e) {
            throw new StartException("Cannot read branding properties from: " + resname);
        }
        System.out.println(brandingProperties.getProperty("welcome"));
    }

    public void stop(StopContext context) {
        if (this.module != null) {
            this.module.uninstall();
        }
    }

    public ZooKeeperClusterBootstrap getValue() throws IllegalStateException {
        return this.bootstrapService;
    }

    private void initConfigurationAdmin(Runtime runtime) {
        ModuleContext syscontext = runtime.getModuleContext();
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)syscontext.getService(syscontext.getServiceReference(ConfigurationAdmin.class));
        File karafEtc = new File((String)runtime.getProperty("karaf.etc"));
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".cfg");
            }
        };
        for (String name : karafEtc.list(filter)) {
            String pid = name.substring(0, name.length() - 4);
            try {
                FileInputStream fis = new FileInputStream(new File(karafEtc, name));
                Properties props = new Properties();
                props.load(fis);
                fis.close();
                Configuration config = configAdmin.getConfiguration(pid, null);
                config.update((Dictionary)props);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }
}

