/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.fabric.parser;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    private SecurityActions() {
    }

    static ClassLoader getClassLoader(Class<?> clazz) {
        return System.getSecurityManager() == null ? clazz.getClassLoader() : AccessController.doPrivileged(new GetClassLoaderAction(clazz));
    }

    static final class GetClassLoaderAction
    implements PrivilegedAction<ClassLoader> {
        private final Class<?> clazz;

        GetClassLoaderAction(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public ClassLoader run() {
            return this.clazz.getClassLoader();
        }
    }
}

