/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.fabric.parser;

import java.util.List;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.dmr.ModelNode;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.fabric.parser.SubsystemState;
import org.wildfly.extension.fabric.service.FabricBootstrapService;
import org.wildfly.extension.fabric.service.FabricRuntimeService;
import org.wildfly.extension.gravia.parser.GraviaSubsystemBootstrap;

final class FabricSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    public FabricSubsystemAdd(SubsystemState subsystemState) {
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        model.setEmptyObject();
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, final ServiceVerificationHandler verificationHandler, final List<ServiceController<?>> newControllers) {
        final FabricSubsystemBootstrap bootstrap = new FabricSubsystemBootstrap();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                newControllers.addAll(bootstrap.getSubsystemServices(context, verificationHandler));
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                bootstrap.addDeploymentUnitProcessors(processorTarget);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }

    static class FabricSubsystemBootstrap
    extends GraviaSubsystemBootstrap {
        FabricSubsystemBootstrap() {
        }

        protected ServiceController<?> getBoostrapService(OperationContext context, ServiceVerificationHandler verificationHandler) {
            return new FabricBootstrapService().install(context.getServiceTarget(), verificationHandler);
        }

        protected ServiceController<Runtime> getRuntimeService(OperationContext context, ServiceVerificationHandler verificationHandler) {
            return new FabricRuntimeService().install(context.getServiceTarget(), verificationHandler);
        }
    }
}

