/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.runtime.container.tomcat;

import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractRuntimeProperties;
import io.fabric8.api.scr.ValidatingReference;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.jboss.gravia.runtime.Runtime;

@ThreadSafe
@Component(label="Tomcat Runtime Properties Service", immediate=true, metatype=false)
@Service(value={RuntimeProperties.class})
public class TomcatPropertiesService
extends AbstractRuntimeProperties {
    @Reference(referenceInterface=Runtime.class)
    private ValidatingReference<Runtime> runtime = new ValidatingReference();

    @Activate
    void activate() throws Exception {
        this.activateInternal();
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    protected String getPropertyInternal(String key, String defaultValue) {
        return (String)((Runtime)this.runtime.get()).getProperty(key, (Object)defaultValue);
    }

    private void activateInternal() {
        Runtime runtime = (Runtime)this.runtime.get();
        if (runtime.getProperty("runtime.id") == null) {
            System.setProperty("runtime.id", "tomcat");
        }
        if (runtime.getProperty("runtime.home") == null) {
            System.setProperty("runtime.home", System.getProperty("catalina.home"));
        }
        if (runtime.getProperty("runtime.data") == null) {
            System.setProperty("runtime.data", runtime.getProperty("runtime.home") + "/work");
        }
        if (runtime.getProperty("runtime.conf") == null) {
            System.setProperty("runtime.conf", runtime.getProperty("runtime.home") + "/conf");
        }
    }

    void bindRuntime(Runtime service) {
        this.runtime.bind((Object)service);
    }

    void unbindRuntime(Runtime service) {
        this.runtime.unbind((Object)service);
    }
}

