/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.runtime.container.tomcat;

import io.fabric8.api.Container;
import io.fabric8.api.ContainerRegistration;
import io.fabric8.api.GeoLocationService;
import io.fabric8.api.PortService;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.ZkDefs;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.internal.ImmutableContainerBuilder;
import io.fabric8.internal.ImmutableContainerImpl;
import io.fabric8.utils.HostUtils;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.bootstrap.BootstrapConfiguration;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.catalina.Server;
import org.apache.catalina.connector.Connector;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.container.registration.tomcat", label="Fabric8 Tomcat Container Registration", immediate=true, metatype=false)
@Service(value={ContainerRegistration.class, ConnectionStateListener.class})
public final class TomcatContainerRegistration
extends AbstractComponent
implements ContainerRegistration,
ConnectionStateListener {
    private transient Logger LOGGER = LoggerFactory.getLogger(TomcatContainerRegistration.class);
    private static final int DEFAULT_HTTP_PORT = 8080;
    private static final int DEFAULT_HTTPS_PORT = 8443;
    @Reference(referenceInterface=MBeanServer.class, bind="bindMBeanServer", unbind="unbindMBeanServer")
    private final ValidatingReference<MBeanServer> mbeanServer = new ValidatingReference();
    @Reference(referenceInterface=RuntimeProperties.class)
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    @Reference(referenceInterface=PortService.class)
    private final ValidatingReference<PortService> portService = new ValidatingReference();
    @Reference(referenceInterface=GeoLocationService.class)
    private final ValidatingReference<GeoLocationService> geoLocationService = new ValidatingReference();
    @Reference(referenceInterface=BootstrapConfiguration.class)
    private final ValidatingReference<BootstrapConfiguration> bootstrapConfiguration = new ValidatingReference();
    private final Set<Connector> httpConnectors = new LinkedHashSet<Connector>();
    private final Set<Connector> httpsConnectors = new LinkedHashSet<Connector>();
    private Server server;
    private String runtimeIdentity;
    private String ip;

    @Activate
    void activate() {
        this.activateInternal();
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    private void activateInternal() {
        RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
        this.runtimeIdentity = sysprops.getRuntimeIdentity();
        String version = sysprops.getProperty("fabric.version", "1.0");
        String profiles = sysprops.getProperty("fabric.profiles");
        try {
            String address;
            this.server = this.getServer();
            if (profiles != null) {
                String versionNode = ZkPath.CONFIG_CONTAINER.getPath(new String[]{this.runtimeIdentity});
                String profileNode = ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{version, this.runtimeIdentity});
                ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)versionNode, (String)version);
                ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)profileNode, (String)profiles);
            }
            this.checkAlive();
            String domainsNode = ZkPath.CONTAINER_DOMAINS.getPath(new String[]{this.runtimeIdentity});
            Stat stat = ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)domainsNode);
            if (stat != null) {
                ZooKeeperUtils.deleteSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)domainsNode);
            }
            ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_BINDADDRESS.getPath(new String[]{this.runtimeIdentity}), (String)((BootstrapConfiguration)this.bootstrapConfiguration.get()).getBindAddress());
            ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{this.runtimeIdentity}), (String)this.getContainerResolutionPolicy((CuratorFramework)this.curator.get(), this.runtimeIdentity));
            ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_LOCAL_HOSTNAME.getPath(new String[]{this.runtimeIdentity}), (String)HostUtils.getLocalHostName());
            ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_LOCAL_IP.getPath(new String[]{this.runtimeIdentity}), (String)HostUtils.getLocalIp());
            ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_IP.getPath(new String[]{this.runtimeIdentity}), (String)TomcatContainerRegistration.getContainerPointer((CuratorFramework)this.curator.get(), this.runtimeIdentity));
            for (String resolver : ZkDefs.VALID_RESOLVERS) {
                address = String.valueOf(((BootstrapConfiguration)this.bootstrapConfiguration.get()).getConfiguration().get(resolver));
                if (address == null || address.isEmpty() || ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_ADDRESS.getPath(new String[]{this.runtimeIdentity, resolver})) != null) continue;
                ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_ADDRESS.getPath(new String[]{this.runtimeIdentity, resolver}), (String)address);
            }
            this.ip = ZooKeeperUtils.getSubstitutedData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)TomcatContainerRegistration.getContainerPointer((CuratorFramework)this.curator.get(), this.runtimeIdentity));
            ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_IP.getPath(new String[]{this.runtimeIdentity}), (String)this.ip);
            ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_GEOLOCATION.getPath(new String[]{this.runtimeIdentity}), (String)((GeoLocationService)this.geoLocationService.get()).getGeoLocation());
            for (String resolver : ZkDefs.VALID_RESOLVERS) {
                address = sysprops.getProperty(resolver);
                if (address == null || address.isEmpty() || ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_ADDRESS.getPath(new String[]{this.runtimeIdentity, resolver})) != null) continue;
                ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_ADDRESS.getPath(new String[]{this.runtimeIdentity, resolver}), (String)address);
            }
            ImmutableContainerImpl current = new ImmutableContainerBuilder().id(this.runtimeIdentity).ip(this.ip).build();
            this.initializeConnectors();
            this.registerHttp((Container)current);
            String minimumPort = sysprops.getProperty("minimum.port");
            String maximumPort = sysprops.getProperty("maximum.port");
            ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_PORT_MIN.getPath(new String[]{this.runtimeIdentity}), (String)minimumPort);
            ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_PORT_MAX.getPath(new String[]{this.runtimeIdentity}), (String)maximumPort);
        }
        catch (Exception e) {
            this.LOGGER.warn("Error updating Fabric Container information. This exception will be ignored.", (Throwable)e);
        }
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        if (this.isValid()) {
            switch (newState) {
                case CONNECTED: 
                case RECONNECTED: {
                    try {
                        this.checkAlive();
                        break;
                    }
                    catch (Exception ex) {
                        this.LOGGER.error("Error while checking/setting container status.");
                    }
                }
            }
        }
    }

    private void checkAlive() throws Exception {
        RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
        String runtimeIdentity = sysprops.getRuntimeIdentity();
        String nodeAlive = ZkPath.CONTAINER_ALIVE.getPath(new String[]{runtimeIdentity});
        Stat stat = ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)nodeAlive);
        if (stat != null) {
            if (stat.getEphemeralOwner() != ((CuratorFramework)this.curator.get()).getZookeeperClient().getZooKeeper().getSessionId()) {
                ZooKeeperUtils.delete((CuratorFramework)((CuratorFramework)this.curator.get()), (String)nodeAlive);
                ZooKeeperUtils.create((CuratorFramework)((CuratorFramework)this.curator.get()), (String)nodeAlive, (CreateMode)CreateMode.EPHEMERAL);
            }
        } else {
            ZooKeeperUtils.create((CuratorFramework)((CuratorFramework)this.curator.get()), (String)nodeAlive, (CreateMode)CreateMode.EPHEMERAL);
        }
    }

    private Server getServer() throws MalformedObjectNameException, AttributeNotFoundException, MBeanException, ReflectionException, InstanceNotFoundException {
        ObjectName name = new ObjectName("Catalina", "type", "Server");
        return (Server)((MBeanServer)this.mbeanServer.get()).getAttribute(name, "managedResource");
    }

    private void initializeConnectors() {
        org.apache.catalina.Service[] services;
        for (org.apache.catalina.Service service : services = this.server.findServices()) {
            for (Connector connector : service.findConnectors()) {
                if (connector.getScheme().equals("http")) {
                    this.httpConnectors.add(connector);
                    continue;
                }
                if (!connector.getScheme().equals("https")) continue;
                this.httpsConnectors.add(connector);
            }
        }
    }

    private void registerHttp(Container container) throws Exception {
        boolean httpEnabled = this.isHttpEnabled();
        boolean httpsEnabled = this.isHttpsEnabled();
        String protocol = httpsEnabled && !httpEnabled ? "https" : "http";
        int httpPort = httpsEnabled && !httpEnabled ? this.getHttpsPort() : this.getHttpPort();
        String httpUrl = this.getHttpUrl(protocol, container.getId(), httpPort);
        ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_HTTP.getPath(new String[]{container.getId()}), (String)httpUrl);
    }

    private boolean isHttpEnabled() throws IOException {
        return !this.httpConnectors.isEmpty();
    }

    private boolean isHttpsEnabled() throws IOException {
        return !this.httpsConnectors.isEmpty();
    }

    private int getHttpPort() {
        int port = 8080;
        Iterator<Connector> i$ = this.httpConnectors.iterator();
        if (i$.hasNext()) {
            Connector connector = i$.next();
            return connector.getPort();
        }
        return port;
    }

    private String getHttpUrl(String protocol, String name, int httpConnectionPort) throws IOException, KeeperException, InterruptedException {
        return protocol + "://${zk:" + name + "/ip}:" + httpConnectionPort;
    }

    private int getHttpsPort() throws KeeperException, InterruptedException, IOException {
        int port = 8443;
        Iterator<Connector> i$ = this.httpsConnectors.iterator();
        if (i$.hasNext()) {
            Connector connector = i$.next();
            return connector.getPort();
        }
        return port;
    }

    private String getGlobalResolutionPolicy(RuntimeProperties sysprops, CuratorFramework zooKeeper) throws Exception {
        String policy = "localhostname";
        List<String> validResolverList = Arrays.asList(ZkDefs.VALID_RESOLVERS);
        if (ZooKeeperUtils.exists((CuratorFramework)zooKeeper, (String)ZkPath.POLICIES.getPath(new String[]{"resolver"})) != null) {
            policy = ZooKeeperUtils.getStringData((CuratorFramework)zooKeeper, (String)ZkPath.POLICIES.getPath(new String[]{"resolver"}));
        } else if (sysprops.getProperty("global.resolver") != null && validResolverList.contains(sysprops.getProperty("global.resolver"))) {
            policy = sysprops.getProperty("global.resolver");
            ZooKeeperUtils.setData((CuratorFramework)zooKeeper, (String)ZkPath.POLICIES.getPath(new String[]{"resolver"}), (String)policy);
        }
        return policy;
    }

    private String getContainerResolutionPolicy(CuratorFramework zooKeeper, String container) throws Exception {
        String policy = null;
        List<String> validResolverList = Arrays.asList(ZkDefs.VALID_RESOLVERS);
        if (ZooKeeperUtils.exists((CuratorFramework)zooKeeper, (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{container})) != null) {
            policy = ZooKeeperUtils.getStringData((CuratorFramework)zooKeeper, (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{container}));
        } else if (((BootstrapConfiguration)this.bootstrapConfiguration.get()).getLocalResolver() != null && validResolverList.contains(((BootstrapConfiguration)this.bootstrapConfiguration.get()).getLocalResolver())) {
            policy = ((BootstrapConfiguration)this.bootstrapConfiguration.get()).getLocalResolver();
        }
        return policy;
    }

    private static String getContainerPointer(CuratorFramework curator, String container) throws Exception {
        String pointer = "${zk:%s/%s}";
        String resolver = "${zk:%s/resolver}";
        return String.format(pointer, container, String.format(resolver, container));
    }

    void bindMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer.bind((Object)mbeanServer);
    }

    void unbindMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer.unbind((Object)mbeanServer);
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }

    void bindPortService(PortService service) {
        this.portService.bind((Object)service);
    }

    void unbindPortService(PortService service) {
        this.portService.unbind((Object)service);
    }

    void bindGeoLocationService(GeoLocationService service) {
        this.geoLocationService.bind((Object)service);
    }

    void unbindGeoLocationService(GeoLocationService service) {
        this.geoLocationService.unbind((Object)service);
    }

    void bindBootstrapConfiguration(BootstrapConfiguration service) {
        this.bootstrapConfiguration.bind((Object)service);
    }

    void unbindBootstrapConfiguration(BootstrapConfiguration service) {
        this.bootstrapConfiguration.unbind((Object)service);
    }
}

