/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.runtime.container;

import io.fabric8.api.gravia.MavenCoordinates;
import io.fabric8.runtime.container.ContainerConfiguration;
import java.io.File;
import java.util.Iterator;
import java.util.ServiceLoader;

public abstract class ContainerConfigurationBuilder {
    public static ContainerConfigurationBuilder create() {
        ServiceLoader<ContainerConfigurationBuilder> loader = ServiceLoader.load(ContainerConfigurationBuilder.class);
        Iterator<ContainerConfigurationBuilder> iterator = loader.iterator();
        if (iterator.hasNext()) {
            ContainerConfigurationBuilder configurationBuilder = iterator.next();
            return configurationBuilder;
        }
        throw new IllegalStateException("Cannot obtain container configuration service");
    }

    protected abstract ContainerConfiguration internalConfiguration();

    public ContainerConfigurationBuilder addMavenCoordinates(MavenCoordinates coordinates) {
        this.internalConfiguration().addMavenCoordinates(coordinates);
        return this;
    }

    public ContainerConfigurationBuilder setTargetDirectory(String target) {
        this.internalConfiguration().setTargetDirectory(new File(target).getAbsoluteFile());
        return this;
    }

    public ContainerConfigurationBuilder setJavaVmArguments(String javaVmArguments) {
        this.internalConfiguration().setJavaVmArguments(javaVmArguments);
        return this;
    }

    public ContainerConfigurationBuilder setOutputToConsole(boolean outputToConsole) {
        this.internalConfiguration().setOutputToConsole(outputToConsole);
        return this;
    }

    public ContainerConfiguration getConfiguration() {
        ContainerConfiguration configuration = this.internalConfiguration();
        configuration.validate();
        configuration.makeImmutable();
        return configuration;
    }
}

