/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.runtime.container;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.gravia.resource.MavenCoordinates;
import org.jboss.gravia.runtime.RuntimeType;
import org.jboss.gravia.utils.IllegalStateAssertion;

public abstract class ContainerConfiguration {
    private List<MavenCoordinates> mavenCoordinates = new ArrayList<MavenCoordinates>();
    private File targetDirectory;
    private String javaVmArguments;
    private boolean outputToConsole;
    private boolean mutable = true;

    public abstract RuntimeType getRuntimeType();

    public List<MavenCoordinates> getMavenCoordinates() {
        return Collections.unmodifiableList(this.mavenCoordinates);
    }

    public void addMavenCoordinates(MavenCoordinates coordinates) {
        this.assertMutable();
        this.mavenCoordinates.add(coordinates);
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    void setTargetDirectory(File target) {
        this.assertMutable();
        this.targetDirectory = target;
    }

    public String getJavaVmArguments() {
        return this.javaVmArguments;
    }

    void setJavaVmArguments(String javaVmArguments) {
        this.assertMutable();
        this.javaVmArguments = javaVmArguments;
    }

    public boolean isOutputToConsole() {
        return this.outputToConsole;
    }

    void setOutputToConsole(boolean outputToConsole) {
        this.outputToConsole = outputToConsole;
    }

    protected void validate() {
        IllegalStateAssertion.assertNotNull(this.mavenCoordinates, (String)"mavenCoordinates");
        IllegalStateAssertion.assertNotNull((Object)this.targetDirectory, (String)"targetDirectory");
    }

    void makeImmutable() {
        this.assertMutable();
        this.mutable = false;
    }

    private void assertMutable() {
        if (!this.mutable) {
            throw new IllegalStateException("Configuration is immutable");
        }
    }
}

