/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.runtime.container;

import io.fabric8.runtime.container.ContainerConfiguration;
import io.fabric8.runtime.container.LifecycleException;
import java.io.File;
import java.util.ServiceLoader;
import org.jboss.gravia.runtime.RuntimeType;

public interface ManagedContainer<T extends ContainerConfiguration> {
    public RuntimeType getRuntimeType();

    public File getContainerHome();

    public State getState();

    public void create(T var1) throws LifecycleException;

    public void start() throws LifecycleException;

    public void stop() throws LifecycleException;

    public void destroy() throws LifecycleException;

    public static class Factory<T extends ContainerConfiguration> {
        public static <T extends ContainerConfiguration> ManagedContainer<T> create(T configuration) throws LifecycleException {
            RuntimeType type = configuration.getRuntimeType();
            ServiceLoader<ManagedContainer> loader = ServiceLoader.load(ManagedContainer.class);
            for (ManagedContainer service : loader) {
                if (service.getRuntimeType() != type) continue;
                service.create(configuration);
                return service;
            }
            throw new IllegalStateException("Cannot obtain managed container service for: " + type);
        }
    }

    public static enum State {
        CREATED,
        STARTED,
        STOPPED,
        DESTROYED;

    }
}

