/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.runsh;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Scanner;

public class RunShLoader {
    private static final String RUN_SCRIPT = "run-java.sh";
    private static final String LOCATION_RUN_SCRIPT = "/run-java-sh/fp-files/run-java.sh";
    private static final String LOCATION_README = "/run-java-sh/readme.md";

    public static void main(String[] args) throws IOException, InterruptedException {
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("help")) {
                RunShLoader.printUsage();
                System.exit(0);
            } else if (args[0].equalsIgnoreCase("readme")) {
                System.out.println(RunShLoader.getReadme());
                System.exit(0);
            } else if (args[0].equalsIgnoreCase("exec")) {
                Path tempDir = Files.createTempDirectory("run-java", new FileAttribute[0]);
                File script = RunShLoader.copyRunScript(tempDir.toFile());
                ProcessBuilder pb = new ProcessBuilder(new String[0]).redirectError(ProcessBuilder.Redirect.INHERIT).redirectInput(ProcessBuilder.Redirect.INHERIT).redirectOutput(ProcessBuilder.Redirect.INHERIT).command(RunShLoader.getExecArgs(args, "/bin/sh", "-c", script.getAbsolutePath()));
                if (System.getenv().get("JAVA_APP_DIR") == null) {
                    pb.environment().put("JAVA_APP_DIR", Paths.get("", new String[0]).toAbsolutePath().toString());
                }
                System.exit(pb.start().waitFor());
            } else if (args[0].equalsIgnoreCase("copy")) {
                if (args.length < 2) {
                    System.err.println("No file name to output to given\n");
                    RunShLoader.printUsage();
                    System.exit(1);
                }
                File script = RunShLoader.copyRunScript(new File(args[1]));
                System.out.println("Created " + script.getAbsolutePath());
            } else {
                System.out.println("Unknown command " + args[0] + "\n");
                RunShLoader.printUsage();
                System.exit(1);
            }
        } else {
            System.out.println(RunShLoader.getRunScript());
        }
    }

    private static void printUsage() {
        System.out.println("Usage: java -jar run-java.jar <command>\n\nwith the following commands:\n\n   help        : This help message\n   copy <file> : Write run-java.sh out to this file or directory\n   readme      : Print the README\n   exec <arg>  : Execute the script directly from the JVM.\n\nNote that this will keep the current JVM running, so you end up with 2 JVMs\n\nBy default (no command) print out the content of this script");
    }

    public static String getReadme() {
        return RunShLoader.loadFromClassPath(LOCATION_README);
    }

    public static String getRunScript() {
        return RunShLoader.loadFromClassPath(LOCATION_RUN_SCRIPT);
    }

    public static File copyRunScript(File destination) throws IOException {
        Path targetPath;
        if (destination.isDirectory()) {
            targetPath = new File(destination, RUN_SCRIPT).toPath();
        } else {
            if (!destination.getAbsoluteFile().getParentFile().exists()) {
                throw new IOException(String.format("%s is not a directory", destination.getParentFile()));
            }
            targetPath = destination.toPath();
        }
        Files.copy(RunShLoader.getInputStream(LOCATION_RUN_SCRIPT), targetPath, StandardCopyOption.REPLACE_EXISTING);
        RunShLoader.setPermissionOnUnix(targetPath);
        return targetPath.toFile();
    }

    private static void setPermissionOnUnix(Path targetPath) throws IOException {
        if (RunShLoader.hasPosixFileSystem(targetPath)) {
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>(Files.getPosixFilePermissions(targetPath, new LinkOption[0]));
            perms.add(PosixFilePermission.OWNER_EXECUTE);
            perms.add(PosixFilePermission.GROUP_EXECUTE);
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
            Files.setPosixFilePermissions(targetPath, perms);
        }
    }

    private static boolean hasPosixFileSystem(Path targetPath) {
        return targetPath.getFileSystem().provider().getFileAttributeView(targetPath, PosixFileAttributeView.class, new LinkOption[0]) != null;
    }

    public static void addExtraFiles(File targetDir) throws IOException {
        File runJavaDir = new File(targetDir, "run-java");
        if (!runJavaDir.exists() && !runJavaDir.mkdir()) {
            throw new IOException("Couldn't create directory " + runJavaDir.getPath());
        }
        RunShLoader.copyRunScript(new File(runJavaDir, RUN_SCRIPT));
    }

    static String loadFromClassPath(String location) {
        try (Scanner s = new Scanner(RunShLoader.getInputStream(location)).useDelimiter("\\A");){
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
    }

    private static InputStream getInputStream(String location) {
        return RunShLoader.class.getResourceAsStream(location);
    }

    private static String[] getExecArgs(String[] mainArgs, String ... scriptArgs) {
        String[] ret = new String[mainArgs.length - 1 + scriptArgs.length];
        int i = 0;
        for (String arg : scriptArgs) {
            ret[i++] = arg;
        }
        int j = 1;
        while (i < mainArgs.length) {
            ret[i++] = mainArgs[j];
            ++j;
        }
        return ret;
    }
}

