/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.spring.boot.starter.activemq;

import io.fabric8.mq.fabric.FabricDiscoveryAgent;
import io.fabric8.process.spring.boot.starter.activemq.BrokerUrlResolver;
import io.fabric8.process.spring.boot.starter.activemq.DefaultBrokerUrlResolver;
import io.fabric8.process.spring.boot.starter.activemq.FabricDiscoveryBrokerUrlResolver;
import io.fabric8.process.spring.boot.starter.activemq.TestBrokerUrlResolver;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.jms.pool.PooledConnectionFactory;
import org.junit.runner.Runner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ActiveMQAutoConfiguration {
    @Value(value="${io.fabric8.process.spring.boot.starter.activemq.broker.url:}")
    String brokerUrl;
    @Autowired
    BrokerUrlResolver brokerUrlResolver;
    @Value(value="${io.fabric8.process.spring.boot.starter.activemq.broker.username:}")
    String brokerUsername;
    @Value(value="${io.fabric8.process.spring.boot.starter.activemq.broker.password:}")
    String brokerPassword;

    @ConditionalOnMissingClass(value={Runner.class, FabricDiscoveryAgent.class})
    @Bean
    BrokerUrlResolver defaultBrokerUrlResolver() {
        return new DefaultBrokerUrlResolver();
    }

    @ConditionalOnClass(value={Runner.class})
    @Bean
    BrokerUrlResolver testBrokerUrlResolver() {
        return new TestBrokerUrlResolver();
    }

    @ConditionalOnClass(value={FabricDiscoveryAgent.class})
    @ConditionalOnMissingClass(value={Runner.class})
    @Bean
    BrokerUrlResolver fabricDiscoveryBrokerUrlResolver() {
        return new FabricDiscoveryBrokerUrlResolver();
    }

    private String resolveBrokerUrl() {
        String resolvedBrokerUrl = !this.brokerUrl.isEmpty() ? this.brokerUrl : this.brokerUrlResolver.brokerUrl();
        return resolvedBrokerUrl;
    }

    @Bean
    ConnectionFactory pooledConnectionFactory() {
        ActiveMQConnectionFactory amqConnectionFactory = new ActiveMQConnectionFactory(this.resolveBrokerUrl());
        if (!this.brokerUsername.isEmpty()) {
            amqConnectionFactory.setUserName(this.brokerUsername);
        }
        if (!this.brokerPassword.isEmpty()) {
            amqConnectionFactory.setPassword(this.brokerPassword);
        }
        PooledConnectionFactory pooledConnectionFactory = new PooledConnectionFactory();
        pooledConnectionFactory.setConnectionFactory((ConnectionFactory)amqConnectionFactory);
        return pooledConnectionFactory;
    }
}

