/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.manager.commands.support;

import io.fabric8.process.manager.InstallOptions;
import io.fabric8.process.manager.ProcessManager;
import io.fabric8.process.manager.commands.support.ProcessCommandSupport;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.felix.gogo.commands.Option;
import org.osgi.framework.BundleContext;

public abstract class InstallActionSupport
extends ProcessCommandSupport {
    @Option(name="-c", aliases={"--controllerUrl"}, required=false, description="The optional JSON document URL containing the controller configuration")
    protected String controllerJson;
    @Option(name="-k", aliases={"--kind"}, required=false, description="The kind of controller to create")
    protected String controllerKind;
    @Option(name="-i", aliases={"--id"}, required=false, description="The ID of the process to create (defaults to an incrementing number)")
    protected String id;
    private final BundleContext bundleContext;

    protected InstallActionSupport(ProcessManager processManager, BundleContext bundleContext) {
        super(processManager);
        this.bundleContext = bundleContext;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    protected URL getControllerURL() throws MalformedURLException {
        URL controllerUrl = null;
        if (this.controllerJson != null) {
            controllerUrl = new URL(this.controllerJson);
        } else if (this.controllerKind != null) {
            String name = this.controllerKind + ".json";
            controllerUrl = this.getBundleContext().getBundle().getResource(name);
            if (controllerUrl == null) {
                throw new IllegalStateException("Cannot find controller kind: " + name + " on the classpath");
            }
        }
        return controllerUrl;
    }

    protected InstallOptions build(InstallOptions.InstallOptionsBuilder builder) throws MalformedURLException {
        if (this.id != null) {
            builder = builder.id(this.id);
        }
        return builder.build();
    }
}

