/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.manager.support;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import io.fabric8.common.util.FileChangeInfo;
import io.fabric8.process.manager.InstallContext;
import io.fabric8.process.manager.InstallTask;
import io.fabric8.process.manager.config.ProcessConfig;
import io.fabric8.process.manager.service.ProcessManagerService;
import io.fabric8.process.manager.support.ProcessUtils;
import io.fabric8.process.manager.support.mvel.MvelPredicate;
import io.fabric8.process.manager.support.mvel.MvelTemplateRendering;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class ApplyConfigurationTask
implements InstallTask {
    private final Map<String, Object> variables;
    private final Map<String, String> configuration;
    private final MvelPredicate isTemplate = new MvelPredicate();

    public ApplyConfigurationTask(Map<String, String> configuration, Map<String, Object> variables) {
        this.configuration = configuration;
        this.variables = variables;
    }

    @Override
    public void install(InstallContext installContext, ProcessConfig config, String id, File installDir) throws Exception {
        Map templates = Maps.filterKeys(this.configuration, (Predicate)this.isTemplate);
        Map plainFiles = Maps.difference(this.configuration, (Map)templates).entriesOnlyOnLeft();
        ProcessManagerService.substituteEnvironmentVariableExpressions(this.variables, config.getEnvironment());
        Map renderedTemplates = Maps.transformValues((Map)templates, (Function)new MvelTemplateRendering(this.variables));
        File baseDir = ProcessUtils.findInstallDir(installDir);
        this.applyTemplates(installContext, renderedTemplates, baseDir);
        this.applyPlainConfiguration(installContext, plainFiles, baseDir);
    }

    private void applyTemplates(InstallContext installContext, Map<String, String> templates, File installDir) throws IOException {
        for (Map.Entry<String, String> entry : templates.entrySet()) {
            String path = entry.getKey();
            String content = entry.getValue();
            String resourcePath = path.substring(path.indexOf("/"));
            resourcePath = resourcePath.substring(0, resourcePath.lastIndexOf(".mvel"));
            this.copyToContent(installContext, installDir, resourcePath, content);
        }
    }

    private void applyPlainConfiguration(InstallContext installContext, Map<String, String> configuration, File installDir) throws IOException {
        for (Map.Entry<String, String> entry : configuration.entrySet()) {
            String path = entry.getKey();
            String content = entry.getValue();
            int slashIndex = path.indexOf("/");
            String resourcePath = slashIndex > 0 ? path.substring(slashIndex) : path;
            this.copyToContent(installContext, installDir, resourcePath, content);
        }
    }

    private void copyToContent(InstallContext installContext, File baseDir, String name, String content) throws IOException {
        File target = new File(baseDir, name);
        FileChangeInfo changeInfo = installContext.createChangeInfo(target);
        if (!(target.exists() || target.getParentFile().exists() || target.getParentFile().mkdirs())) {
            throw new IOException("Directory: " + target.getParentFile().getAbsolutePath() + " can't be created");
        }
        if (target.isDirectory()) {
            throw new IOException("Can't write to : " + target.getAbsolutePath() + ". It's a directory");
        }
        if (!target.exists() && !target.createNewFile()) {
            throw new IOException("Failed to create file: " + target.getAbsolutePath() + ".");
        }
        Files.write((byte[])content.getBytes(Charsets.UTF_8), (File)target);
        String lowerName = name.toLowerCase();
        if (lowerName.endsWith(".sh") || lowerName.endsWith(".bat") || lowerName.endsWith(".cmd")) {
            target.setExecutable(true);
        }
        installContext.onFileWrite(target, changeInfo);
    }
}

