/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.manager;

import io.fabric8.common.util.Processes;
import io.fabric8.process.manager.ProcessController;
import io.fabric8.process.manager.config.ProcessConfig;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;

public class Installation
implements Serializable {
    private static final long serialVersionUID = 5127636210465637719L;
    private final String id;
    private final File installDir;
    private final ProcessController controller;
    private final ProcessConfig config;

    public Installation(String id, File installDir, ProcessController controller, ProcessConfig config) {
        this.id = id;
        this.installDir = installDir;
        this.controller = controller;
        this.config = config;
    }

    public String toString() {
        return "Installation[" + this.getName() + " at " + this.installDir + "]";
    }

    public ProcessController getController() {
        return this.controller;
    }

    public String getId() {
        return this.id;
    }

    public File getInstallDir() {
        return this.installDir;
    }

    public String getName() {
        return this.config.getName();
    }

    public Map<String, String> getEnvironment() {
        return this.config.getEnvironment();
    }

    public Long getActivePid() throws IOException {
        ProcessController aController = this.getController();
        Long answer = null;
        if (aController != null) {
            answer = aController.getPid();
        }
        if (answer != null && !Processes.isProcessAlive((long)answer)) {
            answer = null;
        }
        return answer;
    }
}

