/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.manager.support;

import aQute.lib.osgi.Jar;
import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import io.fabric8.common.util.ChecksumUtils;
import io.fabric8.common.util.FileChangeInfo;
import io.fabric8.common.util.Filter;
import io.fabric8.common.util.Pair;
import io.fabric8.common.util.Strings;
import io.fabric8.fab.DependencyFilters;
import io.fabric8.fab.DependencyTreeResult;
import io.fabric8.fab.MavenResolverImpl;
import io.fabric8.process.manager.InstallContext;
import io.fabric8.process.manager.InstallOptions;
import io.fabric8.process.manager.InstallTask;
import io.fabric8.process.manager.config.ProcessConfig;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.jar.Attributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.resolution.ArtifactResolutionException;

public class JarInstaller
implements InstallTask {
    private static final Logger LOG = LoggerFactory.getLogger(JarInstaller.class);
    MavenResolverImpl mavenResolver = new MavenResolverImpl();
    private final InstallOptions parameters;
    private final Executor executor;

    public JarInstaller(InstallOptions parameters, Executor executor) {
        this.parameters = parameters;
        this.executor = executor;
    }

    @Override
    public void install(InstallContext installContext, ProcessConfig config, String id, File installDir) throws Exception {
        Pair pair;
        String location;
        URL artifactUrl = this.parameters.getUrl();
        File libDir = new File(installDir, "lib");
        libDir.mkdirs();
        HashMap<String, Pair<File, File>> copyFiles = new HashMap<String, Pair<File, File>>();
        if (artifactUrl != null) {
            this.copyArtifactAndDependencies(config, id, installDir, this.parameters, libDir, copyFiles);
        }
        this.copyJarFiles(id, installDir, this.parameters, libDir, copyFiles);
        Set entries = copyFiles.entrySet();
        Map checksums = ChecksumUtils.loadInstalledChecksumCache((File)libDir);
        HashSet filesToRemove = new HashSet();
        filesToRemove.addAll(checksums.keySet());
        for (Map.Entry entry : entries) {
            location = (String)entry.getKey();
            pair = (Pair)entry.getValue();
            File source = (File)pair.getFirst();
            File dest = (File)pair.getSecond();
            long checksum = ChecksumUtils.checksumFile((File)source);
            filesToRemove.remove(dest);
            checksums.put(source, checksum);
        }
        for (File fileToRemove : filesToRemove) {
            LOG.info("Removing: " + fileToRemove);
            checksums.remove(fileToRemove);
            installContext.addRestartReason(fileToRemove);
            fileToRemove.delete();
        }
        ChecksumUtils.saveInstalledChecksumCache((File)libDir, (Map)checksums);
        for (Map.Entry entry : entries) {
            location = (String)entry.getKey();
            pair = (Pair)entry.getValue();
            File sourceFile = (File)pair.getFirst();
            File destFile = (File)pair.getSecond();
            FileChangeInfo oldChangeInfo = installContext.createChangeInfo(destFile);
            Files.copy((File)sourceFile, (File)destFile);
            installContext.onDeploymentFileWrite(location, destFile, oldChangeInfo, true);
        }
    }

    protected void copyJarFiles(String id, File installDir, InstallOptions parameters, File libDir, Map<String, Pair<File, File>> copyFiles) throws IOException {
        Set<Map.Entry<String, File>> entries = parameters.getJarFiles().entrySet();
        for (Map.Entry<String, File> entry : entries) {
            String location = entry.getKey();
            File file = entry.getValue();
            copyFiles.put(location, (Pair<File, File>)new Pair((Object)file, (Object)new File(libDir, file.getName())));
        }
    }

    protected void copyArtifactAndDependencies(ProcessConfig config, String id, File installDir, InstallOptions parameters, File libDir, Map<String, Pair<File, File>> copyFiles) throws Exception {
        URL artifactUrl = parameters.getUrl();
        Filter optionalFilter = DependencyFilters.parseExcludeOptionalFilter((String)Strings.join(Arrays.asList(parameters.getOptionalDependencyPatterns()), (String)" "));
        Filter excludeFilter = DependencyFilters.parseExcludeFilter((String)Strings.join(Arrays.asList(parameters.getExcludeDependencyFilterPatterns()), (String)" "), (Filter)optionalFilter);
        DependencyTreeResult result = this.mavenResolver.collectDependenciesForJar(this.getArtifactFile(artifactUrl), parameters.isOffline(), excludeFilter);
        DependencyNode mainJarDependency = result.getRootNode();
        Artifact mainPomArtifact = mainJarDependency.getDependency().getArtifact();
        File mainJar = this.mavenResolver.resolveArtifact(parameters.isOffline(), mainPomArtifact.getGroupId(), mainPomArtifact.getArtifactId(), mainPomArtifact.getVersion(), mainPomArtifact.getClassifier(), "jar").getFile();
        if (mainJar == null) {
            System.out.println("Cannot find file for main jar " + mainJarDependency);
        } else {
            File newMain = new File(libDir, "main.jar");
            Files.copy((File)mainJar, (File)newMain);
            String mainClass = parameters.getMainClass();
            if (mainClass != null) {
                this.setMainClass(config, installDir, newMain, id, mainClass);
            }
        }
        this.copyDependencies(mainJarDependency, libDir, copyFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getArtifactFile(URL url) throws IOException {
        File tmpFile = File.createTempFile("artifact", ".jar");
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(tmpFile);
            Resources.copy((URL)url, (OutputStream)fos);
        }
        catch (Exception ex) {
            try {
                Throwables.propagate((Throwable)ex);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(fos);
                throw throwable;
            }
            Closeables.closeQuietly((Closeable)fos);
        }
        Closeables.closeQuietly((Closeable)fos);
        return tmpFile;
    }

    protected void setMainClass(ProcessConfig config, File installDir, File jarFile, String id, String mainClass) throws Exception {
        File tmpFile = File.createTempFile("fuse-process-" + id, ".jar");
        Files.copy((File)jarFile, (File)tmpFile);
        Jar jar = new Jar(tmpFile);
        Attributes attributes = jar.getManifest().getMainAttributes();
        attributes.putValue("Main-Class", mainClass);
        jar.write(jarFile);
    }

    protected void copyDependencies(DependencyNode dependency, File libDir, Map<String, Pair<File, File>> copyFiles) throws IOException, ArtifactResolutionException {
        List children = dependency.getChildren();
        if (children != null) {
            for (DependencyNode child : children) {
                String location = this.toLocation(child.getDependency());
                if (child.getDependency().getScope().equals("provided")) {
                    LOG.debug("Dependency {} has scope provided. Not copying.", (Object)child.getDependency());
                    continue;
                }
                File file = this.getFile(child);
                if (file == null) {
                    System.out.println("Cannot find file for dependent jar " + child);
                } else {
                    copyFiles.put(location, (Pair<File, File>)new Pair((Object)file, (Object)new File(libDir, file.getName())));
                }
                this.copyDependencies(child, libDir, copyFiles);
            }
        }
    }

    private String toLocation(Dependency dependency) {
        Artifact artifact = dependency.getArtifact();
        String prefix = "";
        String postfix = "";
        String classifier = artifact.getClassifier();
        String extension = artifact.getExtension();
        if (Strings.isNotBlank((String)extension) && (!extension.equals("jar") || Strings.isNotBlank((String)classifier))) {
            postfix = "/" + extension;
        }
        if (Strings.isNotBlank((String)classifier)) {
            postfix = postfix + "/" + classifier;
        }
        return prefix + "mvn:" + artifact.getGroupId() + "/" + artifact.getArtifactId() + "/" + artifact.getVersion() + postfix;
    }

    protected File getFile(DependencyNode node) throws ArtifactResolutionException {
        Artifact artifact;
        Dependency dependency;
        if (node != null && (dependency = node.getDependency()) != null && (artifact = dependency.getArtifact()) != null) {
            File file = artifact.getFile();
            if (file == null) {
                return this.mavenResolver.resolveFile(artifact);
            }
            return file;
        }
        return null;
    }
}

