/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.manager.support;

import io.fabric8.common.util.ChecksumUtils;
import io.fabric8.common.util.FileChangeInfo;
import io.fabric8.process.manager.InstallContext;
import io.fabric8.process.manager.InstallTask;
import io.fabric8.process.manager.config.ProcessConfig;
import io.fabric8.process.manager.support.ProcessUtils;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallDeploymentsTask
implements InstallTask {
    private static final transient Logger LOG = LoggerFactory.getLogger(InstallDeploymentsTask.class);
    private final Map<String, File> javaArtifacts;

    public InstallDeploymentsTask(Map<String, File> javaArtifacts) {
        this.javaArtifacts = javaArtifacts;
    }

    @Override
    public void install(InstallContext installContext, ProcessConfig config, String id, File installDir) throws Exception {
        File baseDir = ProcessUtils.findInstallDir(installDir);
        String sharedLibraryPath = config.getSharedLibraryPath();
        String deployPath = config.getDeployPath();
        File libraryDir = new File(baseDir, sharedLibraryPath);
        File deployDir = new File(baseDir, deployPath);
        libraryDir.mkdirs();
        deployDir.mkdirs();
        Map deployChecksums = ChecksumUtils.loadInstalledChecksumCache((File)deployDir);
        Map libraryChecksums = ChecksumUtils.loadInstalledChecksumCache((File)libraryDir);
        TreeSet sharedLibraries = new TreeSet();
        TreeSet deployments = new TreeSet();
        HashSet installedFiles = new HashSet();
        Set<Map.Entry<String, File>> entries = this.javaArtifacts.entrySet();
        HashSet filesToDelete = new HashSet();
        filesToDelete.addAll(deployChecksums.keySet());
        filesToDelete.addAll(libraryChecksums.keySet());
        for (int i = 0; i < 2; ++i) {
            boolean deletePass = i == 0;
            for (Map.Entry<String, File> entry : entries) {
                File destDir;
                Map checksums;
                String location = entry.getKey();
                File file = entry.getValue();
                String fileName = file.getName();
                boolean isSharedLibrary = fileName.endsWith(".jar");
                if (isSharedLibrary) {
                    checksums = libraryChecksums;
                    destDir = libraryDir;
                } else {
                    destDir = deployDir;
                    checksums = deployChecksums;
                }
                File destFile = new File(destDir, fileName);
                Long checksum = (Long)checksums.get(destFile);
                if (deletePass) {
                    filesToDelete.remove(destFile);
                    if (checksum != null) continue;
                    checksum = ChecksumUtils.checksumFile((File)file);
                    checksums.put(destFile, checksum);
                    continue;
                }
                FileChangeInfo changeInfo = installContext.createChangeInfo(destFile);
                LOG.debug("Copying file " + fileName + " to :  " + destFile.getCanonicalPath());
                FileUtils.copyFile((File)file, (File)destFile);
                installContext.onDeploymentFileWrite(location, destFile, changeInfo, isSharedLibrary);
            }
            if (!deletePass) continue;
            for (File fileToDelete : filesToDelete) {
                LOG.info("Removing: " + fileToDelete);
                deployChecksums.remove(fileToDelete);
                libraryChecksums.remove(fileToDelete);
                installContext.addRestartReason(fileToDelete);
                fileToDelete.delete();
            }
            ChecksumUtils.saveInstalledChecksumCache((File)deployDir, (Map)deployChecksums);
            ChecksumUtils.saveInstalledChecksumCache((File)libraryDir, (Map)libraryChecksums);
        }
        LOG.info("Deployed " + deployments.size() + " deployment(s)");
        for (String deployment : deployments) {
            LOG.info("   deployed: " + deployment);
        }
        LOG.info("Installed " + sharedLibraries.size() + " shared jar(s)");
        for (String sharedLib : sharedLibraries) {
            LOG.info("   jar: " + sharedLib);
        }
    }
}

