/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.manager.commands.support;

import com.google.common.collect.ImmutableMap;
import io.fabric8.process.manager.Installation;
import io.fabric8.process.manager.commands.support.ProcessCommandSupport;
import org.apache.felix.gogo.commands.Argument;

public abstract class ProcessControlCommandSupport
extends ProcessCommandSupport {
    @Argument(index=0, required=true, multiValued=true, name="id", description="The id of the managed processes to control")
    protected int[] ids;

    protected Object doExecute() throws Exception {
        this.checkRequirements();
        ImmutableMap<Integer, Installation> map = this.getProcessManager().listInstallationMap();
        for (int id : this.ids) {
            Installation installation = (Installation)map.get(id);
            if (installation == null) {
                System.out.println("No such process number: " + id);
                continue;
            }
            this.doControlCommand(installation);
        }
        return null;
    }

    protected abstract void doControlCommand(Installation var1) throws Exception;
}

