/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.manager.commands;

import io.fabric8.process.manager.Installation;
import io.fabric8.process.manager.commands.support.ProcessCommandSupport;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.apache.felix.gogo.commands.Command;

@Command(name="ps", scope="process", description="Lists the currently installed managed processes.")
public class ProcessList
extends ProcessCommandSupport {
    static final String[] HEADERS = new String[]{"[id]", "[pid]", "[name]"};
    static final String FORMAT = "%7s %9s %s";

    protected Object doExecute() throws Exception {
        this.checkRequirements();
        List<Installation> installations = this.getProcessManager().listInstallations();
        this.printInstallations(installations, System.out);
        return null;
    }

    protected void printInstallations(List<Installation> installations, PrintStream out) {
        out.println(String.format(FORMAT, HEADERS));
        for (Installation installation : installations) {
            int id = installation.getId();
            Integer pid = null;
            try {
                pid = installation.getController().getPid();
            }
            catch (IOException e) {
                System.err.println("Failed to find pid for id: " + id + ". " + e);
            }
            out.println(String.format(FORMAT, "" + id, pid != null ? pid.toString() : "", installation.getName()));
        }
    }
}

