/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.fabric.child.tasks;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import io.fabric8.process.fabric.child.support.MvelPredicate;
import io.fabric8.process.fabric.child.support.MvelTemplateRendering;
import io.fabric8.process.manager.InstallTask;
import io.fabric8.process.manager.config.ProcessConfig;
import io.fabric8.process.manager.support.ProcessUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class ApplyConfigurationTask
implements InstallTask {
    private final Map<String, Object> variables;
    private final Map<String, String> configuration;
    private final MvelPredicate isTemplate = new MvelPredicate();

    public ApplyConfigurationTask(Map<String, String> configuration, Map<String, Object> variables) {
        this.configuration = configuration;
        this.variables = variables;
    }

    public void install(ProcessConfig config, String id, File installDir) throws Exception {
        Map templates = Maps.filterKeys(this.configuration, (Predicate)this.isTemplate);
        Map plainFiles = Maps.difference(this.configuration, (Map)templates).entriesOnlyOnLeft();
        Map renderedTemplates = Maps.transformValues((Map)templates, (Function)new MvelTemplateRendering(this.variables));
        File baseDir = ProcessUtils.findInstallDir((File)installDir);
        this.applyTemplates(renderedTemplates, baseDir);
        this.applyPlainConfiguration(plainFiles, baseDir);
    }

    private void applyTemplates(Map<String, String> templates, File installDir) throws IOException {
        for (Map.Entry<String, String> entry : templates.entrySet()) {
            String path = entry.getKey();
            String content = entry.getValue();
            String resourcePath = path.substring(path.indexOf("/"));
            resourcePath = resourcePath.substring(0, resourcePath.lastIndexOf(".mvel"));
            this.copyToContent(installDir, resourcePath, content);
        }
    }

    private void applyPlainConfiguration(Map<String, String> configuration, File installDir) throws IOException {
        for (Map.Entry<String, String> entry : configuration.entrySet()) {
            String path = entry.getKey();
            String content = entry.getValue();
            int slashIndex = path.indexOf("/");
            String resourcePath = slashIndex > 0 ? path.substring(slashIndex) : path;
            this.copyToContent(installDir, resourcePath, content);
        }
    }

    private void copyToContent(File baseDir, String name, String content) throws IOException {
        File target = new File(baseDir, name);
        if (!(target.exists() || target.getParentFile().exists() || target.getParentFile().mkdirs())) {
            throw new IOException("Directory: " + target.getParentFile().getAbsolutePath() + " can't be created");
        }
        if (target.isDirectory()) {
            throw new IOException("Can't write to : " + target.getAbsolutePath() + ". It's a directory");
        }
        if (!target.exists() && !target.createNewFile()) {
            throw new IOException("Failed to create file: " + target.getAbsolutePath() + ".");
        }
        Files.write((byte[])content.getBytes(Charsets.UTF_8), (File)target);
    }
}

