/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.process.fabric.commands;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.apache.felix.gogo.commands.Command;
import org.fusesource.process.fabric.ContainerInstallOptions;
import org.fusesource.process.fabric.commands.ContainerProcessCommandSupport;
import org.fusesource.process.manager.Installation;

@Command(name="ps", scope="process", description="Lists the currently installed managed processes.")
public class ProcessList
extends ContainerProcessCommandSupport {
    static final String[] HEADERS = new String[]{"[id]", "[pid]", "[name]"};
    static final String FORMAT = "%7s %9s %s";

    @Override
    void doWithAuthentication(String jmxUser, String jmxPassword) throws Exception {
        ContainerInstallOptions options = ContainerInstallOptions.builder().container(this.container).user(jmxUser).password(jmxPassword).build();
        List<Installation> installations = this.getContainerProcessManager().listInstallations(options);
        this.printInstallations(installations, System.out);
    }

    protected void printInstallations(List<Installation> installations, PrintStream out) {
        out.println(String.format(FORMAT, HEADERS));
        for (Installation installation : installations) {
            int id = installation.getId();
            Integer pid = null;
            try {
                pid = installation.getController().getPid();
            }
            catch (IOException e) {
                System.err.println("Failed to find pid for id: " + id + ". " + e);
            }
            out.println(String.format(FORMAT, "" + id, pid != null ? pid.toString() : "", installation.getName()));
        }
    }
}

