/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.process.fabric.child.tasks;

import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.utils.AgentUtils;
import io.fabric8.api.Profile;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.features.Feature;
import org.codehaus.plexus.util.FileUtils;
import org.fusesource.process.manager.InstallTask;
import org.fusesource.process.manager.config.ProcessConfig;
import org.fusesource.process.manager.support.ProcessUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentTask
implements InstallTask {
    private static final transient Logger LOG = LoggerFactory.getLogger(DeploymentTask.class);
    private static String PAX_URL_MVN_PID = "org.ops4j.pax.url.mvn";
    private final DownloadManager downloadManager;
    private final Profile profile;

    public DeploymentTask(DownloadManager downloadManager, Profile profile) {
        this.downloadManager = downloadManager;
        this.profile = profile;
    }

    public void install(ProcessConfig config, int id, File installDir) throws Exception {
        File baseDir = ProcessUtils.findInstallDir((File)installDir);
        LinkedHashSet<String> bundles = new LinkedHashSet<String>(this.profile.getBundles());
        Set<Feature> features = this.getFeatures(this.profile);
        LOG.info("Deploying into external container features " + features + " and bundles " + bundles);
        Map<String, File> files = AgentUtils.downloadBundles(this.downloadManager, features, bundles, Collections.<String>emptySet());
        Set<Map.Entry<String, File>> entries = files.entrySet();
        for (Map.Entry<String, File> entry : entries) {
            String name = entry.getKey();
            File file = entry.getValue();
            String fileName = file.getName();
            String destPath = name.startsWith("war:") || name.contains("/war/") || fileName.toLowerCase().endsWith(".war") ? config.getDeployPath() : config.getSharedLibraryPath();
            File destDir = new File(baseDir, destPath);
            File destFile = new File(destDir, fileName);
            LOG.debug("Copying file " + fileName + " to :  " + destFile.getCanonicalPath());
            FileUtils.copyFile((File)file, (File)destFile);
        }
    }

    public Set<Feature> getFeatures(Profile p) throws Exception {
        LinkedHashSet<Feature> features = new LinkedHashSet<Feature>();
        AgentUtils.addFeatures(features, this.downloadManager, p);
        return features;
    }
}

