/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.process.fabric.child;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.download.DownloadManagers;
import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.internal.ProfileOverlayImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.fusesource.common.util.Objects;
import org.fusesource.process.fabric.child.ProcessProfile;
import org.fusesource.process.fabric.child.ProcessRequirements;
import org.fusesource.process.fabric.child.support.ByteToStringValues;
import org.fusesource.process.fabric.child.support.LayOutPredicate;
import org.fusesource.process.fabric.child.tasks.ApplyConfigurationTask;
import org.fusesource.process.fabric.child.tasks.CompositeTask;
import org.fusesource.process.fabric.child.tasks.DeploymentTask;
import org.fusesource.process.manager.InstallOptions;
import org.fusesource.process.manager.InstallTask;
import org.fusesource.process.manager.Installation;
import org.fusesource.process.manager.ProcessController;
import org.fusesource.process.manager.ProcessManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildProcessManager {
    private static final transient Logger LOG = LoggerFactory.getLogger(ChildProcessManager.class);
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private FabricService fabricService;
    private ProcessManager processManager;

    public void destroy() {
        this.executorService.shutdown();
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public ProcessManager getProcessManager() {
        return this.processManager;
    }

    public void setProcessManager(ProcessManager processManager) {
        this.processManager = processManager;
    }

    Installation provisionProcess(ProcessRequirements requirements) throws Exception {
        this.uninstallProcess(requirements);
        String id = requirements.getId();
        InstallOptions installOptions = requirements.createInstallOptions();
        Profile processProfile = this.getProcessProfile(requirements, true);
        Profile deployProcessProfile = this.getProcessProfile(requirements, false);
        Map<String, String> configuration = this.getProcessLayout(processProfile, requirements.getLayout());
        DownloadManager downloadManager = DownloadManagers.createDownloadManager(this.fabricService, processProfile, this.executorService);
        ApplyConfigurationTask applyConfiguration = new ApplyConfigurationTask(configuration, installOptions.getProperties());
        DeploymentTask applyProfile = new DeploymentTask(downloadManager, deployProcessProfile);
        CompositeTask compositeTask = new CompositeTask(applyConfiguration, applyProfile);
        Installation installation = this.processManager.install(installOptions, (InstallTask)compositeTask);
        if (installation != null) {
            installation.getController().start();
        }
        return installation;
    }

    void uninstallProcess(ProcessRequirements requirements) throws Exception {
        String id = requirements.getId();
        Installation installation = this.findProcessInstallation(id);
        if (installation != null) {
            ProcessController controller = installation.getController();
            try {
                controller.stop();
            }
            catch (Exception e) {
                LOG.warn("Ignored exception while trying to stop process " + installation + " " + e);
            }
            controller.uninstall();
            controller = null;
        }
    }

    protected Profile getProcessProfile(ProcessRequirements requirements, boolean includeController) {
        Container container = this.fabricService.getCurrentContainer();
        ProcessProfile profile = new ProcessProfile(container, requirements, this.fabricService, includeController);
        return new ProfileOverlayImpl((Profile)profile, this.fabricService.getEnvironment(), true, this.fabricService);
    }

    protected Map<String, String> getProcessLayout(Profile profile, String layoutPath) {
        return ByteToStringValues.INSTANCE.apply(Maps.filterKeys((Map)profile.getFileConfigurations(), (Predicate)new LayOutPredicate(layoutPath)));
    }

    protected Installation findProcessInstallation(String id) {
        List installations = this.processManager.listInstallations();
        for (Installation installation : installations) {
            String name = installation.getName();
            if (!Objects.equal((Object)id, (Object)name)) continue;
            return installation;
        }
        return null;
    }
}

