/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.process.fabric.child;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.fusesource.process.fabric.child.ChildProcessManager;
import org.fusesource.process.fabric.child.DeploymentInfo;
import org.fusesource.process.fabric.child.ProcessRequirements;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildProcessFactory
implements ManagedServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ChildProcessFactory.class);
    private static final String KIND = "kind";
    private static final String URL = "url";
    private static final String EXTRACT_CMD = "extractCmd";
    private static final String PROFILES = "profiles";
    private static final String LAYOUT = "layout";
    private static final String NAME = "Child Process Manager Factory";
    private String id;
    private String kind;
    private String url;
    private List<DeploymentInfo> deployments = new ArrayList<DeploymentInfo>();
    private List<String> profiles = new ArrayList<String>();
    private final ConcurrentMap<String, ProcessRequirements> requirements = new ConcurrentHashMap<String, ProcessRequirements>();
    private ChildProcessManager childProcessManager;

    public String getName() {
        return NAME;
    }

    public void updated(String pid, Dictionary<String, ?> properties) throws ConfigurationException {
        if (properties != null) {
            ProcessRequirements processRequirements = this.loadProcessRequirements(pid, properties);
            try {
                this.requirements.put(pid, processRequirements);
                this.childProcessManager.provisionProcess(processRequirements);
            }
            catch (Exception e) {
                LOG.error("Failed to provision process " + this.requirements + ". " + e, (Throwable)e);
            }
        }
    }

    public void deleted(String pid) {
        ProcessRequirements processRequirements = (ProcessRequirements)this.requirements.get(pid);
        try {
            if (processRequirements != null) {
                this.childProcessManager.uninstallProcess(processRequirements);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to uninstall process " + this.requirements + ". " + e, (Throwable)e);
        }
    }

    private ProcessRequirements loadProcessRequirements(String pid, Dictionary<String, ?> properties) {
        String id = pid.substring(pid.indexOf("-") + 1);
        String kind = String.valueOf(properties.get(KIND));
        String url = String.valueOf(properties.get(URL));
        String extractCmd = this.getOptionalProperty(properties.get(EXTRACT_CMD));
        String layout = String.valueOf(properties.get(LAYOUT));
        String[] profiles = String.valueOf(properties.get(PROFILES)).split(" ");
        ProcessRequirements processRequirements = new ProcessRequirements(id);
        processRequirements.setKind(kind);
        processRequirements.setUrl(url);
        processRequirements.setExtractCmd(extractCmd);
        processRequirements.setLayout(layout);
        for (String profile : profiles) {
            if (profile == null || profile.isEmpty()) continue;
            processRequirements.addProfile(profile);
        }
        Enumeration<String> e = properties.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            Object value = properties.get(key);
            processRequirements.getProperties().put(key, value);
        }
        return processRequirements;
    }

    private String getOptionalProperty(Object property) {
        if (property == null) {
            return "tar zxf";
        }
        String strValue = property.toString().trim();
        return !strValue.isEmpty() ? strValue : null;
    }

    public ChildProcessManager getChildProcessManager() {
        return this.childProcessManager;
    }

    public void setChildProcessManager(ChildProcessManager childProcessManager) {
        this.childProcessManager = childProcessManager;
    }
}

