/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.commands;

import io.fabric8.patch.Patch;
import io.fabric8.patch.PatchException;
import io.fabric8.patch.Result;
import io.fabric8.patch.Service;
import io.fabric8.patch.commands.PatchActionSupport;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;

@Command(scope="patch", name="install", description="Install a patch")
public class InstallAction
extends PatchActionSupport {
    @Argument(name="PATCH", description="name of the patch to install", required=true, multiValued=false)
    String patchId;
    @Option(name="--force", description="Force the installation of the patch")
    boolean force;
    @Option(name="--synchronous", description="Synchronous installation (use with caution)")
    boolean synchronous;

    InstallAction(Service service) {
        super(service);
    }

    @Override
    protected void doExecute(Service service) throws Exception {
        Patch patch = service.getPatch(this.patchId);
        if (patch == null) {
            throw new PatchException("Patch '" + this.patchId + "' not found");
        }
        if (patch.isInstalled()) {
            throw new PatchException("Patch '" + this.patchId + "' is already installed");
        }
        Result result = patch.install(this.force, this.synchronous);
        this.display(result);
    }
}

