/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.commands;

import io.fabric8.patch.Patch;
import io.fabric8.patch.PatchException;
import io.fabric8.patch.Service;
import io.fabric8.patch.commands.PatchCommandSupport;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;

@Command(scope="patch", name="rollback", description="Rollback a patch installation")
public class Rollback
extends PatchCommandSupport {
    @Argument(name="PATCH", description="name of the patch to rollback", required=true, multiValued=false)
    String patchId;

    @Override
    protected void doExecute(Service service) throws Exception {
        Patch patch = service.getPatch(this.patchId);
        if (patch == null) {
            throw new PatchException("Patch '" + this.patchId + "' not found");
        }
        if (!patch.isInstalled()) {
            throw new PatchException("Patch '" + this.patchId + "' is not installed");
        }
        patch.rollback(false);
    }
}

