package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OAuthRedirectReferenceBuilder extends OAuthRedirectReferenceFluent<OAuthRedirectReferenceBuilder> implements VisitableBuilder<OAuthRedirectReference,OAuthRedirectReferenceBuilder>{
  public OAuthRedirectReferenceBuilder() {
    this(new OAuthRedirectReference());
  }
  
  public OAuthRedirectReferenceBuilder(OAuthRedirectReferenceFluent<?> fluent) {
    this(fluent, new OAuthRedirectReference());
  }
  
  public OAuthRedirectReferenceBuilder(OAuthRedirectReferenceFluent<?> fluent,OAuthRedirectReference instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OAuthRedirectReferenceBuilder(OAuthRedirectReference instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OAuthRedirectReferenceFluent<?> fluent;
  
  public OAuthRedirectReference build() {
    OAuthRedirectReference buildable = new OAuthRedirectReference(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildReference());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}