package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class OAuthClientFluent<A extends OAuthClientFluent<A>> extends BaseFluent<A>{
  public OAuthClientFluent() {
  }
  
  public OAuthClientFluent(OAuthClient instance) {
    this.copyInstance(instance);
  }
  private Integer accessTokenInactivityTimeoutSeconds;
  private Integer accessTokenMaxAgeSeconds;
  private List<String> additionalSecrets = new ArrayList<String>();
  private String apiVersion;
  private String grantMethod;
  private String kind;
  private ObjectMetaBuilder metadata;
  private List<String> redirectURIs = new ArrayList<String>();
  private Boolean respondWithChallenges;
  private ArrayList<ScopeRestrictionBuilder> scopeRestrictions = new ArrayList<ScopeRestrictionBuilder>();
  private String secret;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(OAuthClient instance) {
    instance = (instance != null ? instance : new OAuthClient());
    if (instance != null) {
          this.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds());
          this.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds());
          this.withAdditionalSecrets(instance.getAdditionalSecrets());
          this.withApiVersion(instance.getApiVersion());
          this.withGrantMethod(instance.getGrantMethod());
          this.withKind(instance.getKind());
          this.withMetadata(instance.getMetadata());
          this.withRedirectURIs(instance.getRedirectURIs());
          this.withRespondWithChallenges(instance.getRespondWithChallenges());
          this.withScopeRestrictions(instance.getScopeRestrictions());
          this.withSecret(instance.getSecret());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Integer getAccessTokenInactivityTimeoutSeconds() {
    return this.accessTokenInactivityTimeoutSeconds;
  }
  
  public A withAccessTokenInactivityTimeoutSeconds(Integer accessTokenInactivityTimeoutSeconds) {
    this.accessTokenInactivityTimeoutSeconds = accessTokenInactivityTimeoutSeconds;
    return (A) this;
  }
  
  public boolean hasAccessTokenInactivityTimeoutSeconds() {
    return this.accessTokenInactivityTimeoutSeconds != null;
  }
  
  public Integer getAccessTokenMaxAgeSeconds() {
    return this.accessTokenMaxAgeSeconds;
  }
  
  public A withAccessTokenMaxAgeSeconds(Integer accessTokenMaxAgeSeconds) {
    this.accessTokenMaxAgeSeconds = accessTokenMaxAgeSeconds;
    return (A) this;
  }
  
  public boolean hasAccessTokenMaxAgeSeconds() {
    return this.accessTokenMaxAgeSeconds != null;
  }
  
  public A addToAdditionalSecrets(int index,String item) {
    if (this.additionalSecrets == null) {this.additionalSecrets = new ArrayList<String>();}
    this.additionalSecrets.add(index, item);
    return (A)this;
  }
  
  public A setToAdditionalSecrets(int index,String item) {
    if (this.additionalSecrets == null) {this.additionalSecrets = new ArrayList<String>();}
    this.additionalSecrets.set(index, item); return (A)this;
  }
  
  public A addToAdditionalSecrets(java.lang.String... items) {
    if (this.additionalSecrets == null) {this.additionalSecrets = new ArrayList<String>();}
    for (String item : items) {this.additionalSecrets.add(item);} return (A)this;
  }
  
  public A addAllToAdditionalSecrets(Collection<String> items) {
    if (this.additionalSecrets == null) {this.additionalSecrets = new ArrayList<String>();}
    for (String item : items) {this.additionalSecrets.add(item);} return (A)this;
  }
  
  public A removeFromAdditionalSecrets(java.lang.String... items) {
    if (this.additionalSecrets == null) return (A)this;
    for (String item : items) { this.additionalSecrets.remove(item);} return (A)this;
  }
  
  public A removeAllFromAdditionalSecrets(Collection<String> items) {
    if (this.additionalSecrets == null) return (A)this;
    for (String item : items) { this.additionalSecrets.remove(item);} return (A)this;
  }
  
  public List<String> getAdditionalSecrets() {
    return this.additionalSecrets;
  }
  
  public String getAdditionalSecret(int index) {
    return this.additionalSecrets.get(index);
  }
  
  public String getFirstAdditionalSecret() {
    return this.additionalSecrets.get(0);
  }
  
  public String getLastAdditionalSecret() {
    return this.additionalSecrets.get(additionalSecrets.size() - 1);
  }
  
  public String getMatchingAdditionalSecret(Predicate<String> predicate) {
      for (String item : additionalSecrets) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingAdditionalSecret(Predicate<String> predicate) {
      for (String item : additionalSecrets) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAdditionalSecrets(List<String> additionalSecrets) {
    if (additionalSecrets != null) {
        this.additionalSecrets = new ArrayList();
        for (String item : additionalSecrets) {
          this.addToAdditionalSecrets(item);
        }
    } else {
      this.additionalSecrets = null;
    }
    return (A) this;
  }
  
  public A withAdditionalSecrets(java.lang.String... additionalSecrets) {
    if (this.additionalSecrets != null) {
        this.additionalSecrets.clear();
        _visitables.remove("additionalSecrets");
    }
    if (additionalSecrets != null) {
      for (String item : additionalSecrets) {
        this.addToAdditionalSecrets(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAdditionalSecrets() {
    return this.additionalSecrets != null && !this.additionalSecrets.isEmpty();
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public String getGrantMethod() {
    return this.grantMethod;
  }
  
  public A withGrantMethod(String grantMethod) {
    this.grantMethod = grantMethod;
    return (A) this;
  }
  
  public boolean hasGrantMethod() {
    return this.grantMethod != null;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public ObjectMeta buildMetadata() {
    return this.metadata != null ? this.metadata.build() : null;
  }
  
  public A withMetadata(ObjectMeta metadata) {
    this._visitables.remove("metadata");
    if (metadata != null) {
        this.metadata = new ObjectMetaBuilder(metadata);
        this._visitables.get("metadata").add(this.metadata);
    } else {
        this.metadata = null;
        this._visitables.get("metadata").remove(this.metadata);
    }
    return (A) this;
  }
  
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  
  public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new MetadataNested(item);
  }
  
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new ObjectMetaBuilder().build()));
  }
  
  public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  
  public A addToRedirectURIs(int index,String item) {
    if (this.redirectURIs == null) {this.redirectURIs = new ArrayList<String>();}
    this.redirectURIs.add(index, item);
    return (A)this;
  }
  
  public A setToRedirectURIs(int index,String item) {
    if (this.redirectURIs == null) {this.redirectURIs = new ArrayList<String>();}
    this.redirectURIs.set(index, item); return (A)this;
  }
  
  public A addToRedirectURIs(java.lang.String... items) {
    if (this.redirectURIs == null) {this.redirectURIs = new ArrayList<String>();}
    for (String item : items) {this.redirectURIs.add(item);} return (A)this;
  }
  
  public A addAllToRedirectURIs(Collection<String> items) {
    if (this.redirectURIs == null) {this.redirectURIs = new ArrayList<String>();}
    for (String item : items) {this.redirectURIs.add(item);} return (A)this;
  }
  
  public A removeFromRedirectURIs(java.lang.String... items) {
    if (this.redirectURIs == null) return (A)this;
    for (String item : items) { this.redirectURIs.remove(item);} return (A)this;
  }
  
  public A removeAllFromRedirectURIs(Collection<String> items) {
    if (this.redirectURIs == null) return (A)this;
    for (String item : items) { this.redirectURIs.remove(item);} return (A)this;
  }
  
  public List<String> getRedirectURIs() {
    return this.redirectURIs;
  }
  
  public String getRedirectURI(int index) {
    return this.redirectURIs.get(index);
  }
  
  public String getFirstRedirectURI() {
    return this.redirectURIs.get(0);
  }
  
  public String getLastRedirectURI() {
    return this.redirectURIs.get(redirectURIs.size() - 1);
  }
  
  public String getMatchingRedirectURI(Predicate<String> predicate) {
      for (String item : redirectURIs) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingRedirectURI(Predicate<String> predicate) {
      for (String item : redirectURIs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withRedirectURIs(List<String> redirectURIs) {
    if (redirectURIs != null) {
        this.redirectURIs = new ArrayList();
        for (String item : redirectURIs) {
          this.addToRedirectURIs(item);
        }
    } else {
      this.redirectURIs = null;
    }
    return (A) this;
  }
  
  public A withRedirectURIs(java.lang.String... redirectURIs) {
    if (this.redirectURIs != null) {
        this.redirectURIs.clear();
        _visitables.remove("redirectURIs");
    }
    if (redirectURIs != null) {
      for (String item : redirectURIs) {
        this.addToRedirectURIs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasRedirectURIs() {
    return this.redirectURIs != null && !this.redirectURIs.isEmpty();
  }
  
  public Boolean getRespondWithChallenges() {
    return this.respondWithChallenges;
  }
  
  public A withRespondWithChallenges(Boolean respondWithChallenges) {
    this.respondWithChallenges = respondWithChallenges;
    return (A) this;
  }
  
  public boolean hasRespondWithChallenges() {
    return this.respondWithChallenges != null;
  }
  
  public A addToScopeRestrictions(int index,ScopeRestriction item) {
    if (this.scopeRestrictions == null) {this.scopeRestrictions = new ArrayList<ScopeRestrictionBuilder>();}
    ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);
    if (index < 0 || index >= scopeRestrictions.size()) {
        _visitables.get("scopeRestrictions").add(builder);
        scopeRestrictions.add(builder);
    } else {
        _visitables.get("scopeRestrictions").add(builder);
        scopeRestrictions.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToScopeRestrictions(int index,ScopeRestriction item) {
    if (this.scopeRestrictions == null) {this.scopeRestrictions = new ArrayList<ScopeRestrictionBuilder>();}
    ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);
    if (index < 0 || index >= scopeRestrictions.size()) {
        _visitables.get("scopeRestrictions").add(builder);
        scopeRestrictions.add(builder);
    } else {
        _visitables.get("scopeRestrictions").add(builder);
        scopeRestrictions.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToScopeRestrictions(io.fabric8.openshift.api.model.ScopeRestriction... items) {
    if (this.scopeRestrictions == null) {this.scopeRestrictions = new ArrayList<ScopeRestrictionBuilder>();}
    for (ScopeRestriction item : items) {ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);_visitables.get("scopeRestrictions").add(builder);this.scopeRestrictions.add(builder);} return (A)this;
  }
  
  public A addAllToScopeRestrictions(Collection<ScopeRestriction> items) {
    if (this.scopeRestrictions == null) {this.scopeRestrictions = new ArrayList<ScopeRestrictionBuilder>();}
    for (ScopeRestriction item : items) {ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);_visitables.get("scopeRestrictions").add(builder);this.scopeRestrictions.add(builder);} return (A)this;
  }
  
  public A removeFromScopeRestrictions(io.fabric8.openshift.api.model.ScopeRestriction... items) {
    if (this.scopeRestrictions == null) return (A)this;
    for (ScopeRestriction item : items) {ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);_visitables.get("scopeRestrictions").remove(builder); this.scopeRestrictions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromScopeRestrictions(Collection<ScopeRestriction> items) {
    if (this.scopeRestrictions == null) return (A)this;
    for (ScopeRestriction item : items) {ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);_visitables.get("scopeRestrictions").remove(builder); this.scopeRestrictions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromScopeRestrictions(Predicate<ScopeRestrictionBuilder> predicate) {
    if (scopeRestrictions == null) return (A) this;
    final Iterator<ScopeRestrictionBuilder> each = scopeRestrictions.iterator();
    final List visitables = _visitables.get("scopeRestrictions");
    while (each.hasNext()) {
      ScopeRestrictionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ScopeRestriction> buildScopeRestrictions() {
    return this.scopeRestrictions != null ? build(scopeRestrictions) : null;
  }
  
  public ScopeRestriction buildScopeRestriction(int index) {
    return this.scopeRestrictions.get(index).build();
  }
  
  public ScopeRestriction buildFirstScopeRestriction() {
    return this.scopeRestrictions.get(0).build();
  }
  
  public ScopeRestriction buildLastScopeRestriction() {
    return this.scopeRestrictions.get(scopeRestrictions.size() - 1).build();
  }
  
  public ScopeRestriction buildMatchingScopeRestriction(Predicate<ScopeRestrictionBuilder> predicate) {
      for (ScopeRestrictionBuilder item : scopeRestrictions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingScopeRestriction(Predicate<ScopeRestrictionBuilder> predicate) {
      for (ScopeRestrictionBuilder item : scopeRestrictions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withScopeRestrictions(List<ScopeRestriction> scopeRestrictions) {
    if (this.scopeRestrictions != null) {
      this._visitables.get("scopeRestrictions").clear();
    }
    if (scopeRestrictions != null) {
        this.scopeRestrictions = new ArrayList();
        for (ScopeRestriction item : scopeRestrictions) {
          this.addToScopeRestrictions(item);
        }
    } else {
      this.scopeRestrictions = null;
    }
    return (A) this;
  }
  
  public A withScopeRestrictions(io.fabric8.openshift.api.model.ScopeRestriction... scopeRestrictions) {
    if (this.scopeRestrictions != null) {
        this.scopeRestrictions.clear();
        _visitables.remove("scopeRestrictions");
    }
    if (scopeRestrictions != null) {
      for (ScopeRestriction item : scopeRestrictions) {
        this.addToScopeRestrictions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasScopeRestrictions() {
    return this.scopeRestrictions != null && !this.scopeRestrictions.isEmpty();
  }
  
  public ScopeRestrictionsNested<A> addNewScopeRestriction() {
    return new ScopeRestrictionsNested(-1, null);
  }
  
  public ScopeRestrictionsNested<A> addNewScopeRestrictionLike(ScopeRestriction item) {
    return new ScopeRestrictionsNested(-1, item);
  }
  
  public ScopeRestrictionsNested<A> setNewScopeRestrictionLike(int index,ScopeRestriction item) {
    return new ScopeRestrictionsNested(index, item);
  }
  
  public ScopeRestrictionsNested<A> editScopeRestriction(int index) {
    if (scopeRestrictions.size() <= index) throw new RuntimeException("Can't edit scopeRestrictions. Index exceeds size.");
    return setNewScopeRestrictionLike(index, buildScopeRestriction(index));
  }
  
  public ScopeRestrictionsNested<A> editFirstScopeRestriction() {
    if (scopeRestrictions.size() == 0) throw new RuntimeException("Can't edit first scopeRestrictions. The list is empty.");
    return setNewScopeRestrictionLike(0, buildScopeRestriction(0));
  }
  
  public ScopeRestrictionsNested<A> editLastScopeRestriction() {
    int index = scopeRestrictions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last scopeRestrictions. The list is empty.");
    return setNewScopeRestrictionLike(index, buildScopeRestriction(index));
  }
  
  public ScopeRestrictionsNested<A> editMatchingScopeRestriction(Predicate<ScopeRestrictionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<scopeRestrictions.size();i++) { 
    if (predicate.test(scopeRestrictions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching scopeRestrictions. No match found.");
    return setNewScopeRestrictionLike(index, buildScopeRestriction(index));
  }
  
  public String getSecret() {
    return this.secret;
  }
  
  public A withSecret(String secret) {
    this.secret = secret;
    return (A) this;
  }
  
  public boolean hasSecret() {
    return this.secret != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OAuthClientFluent that = (OAuthClientFluent) o;
    if (!java.util.Objects.equals(accessTokenInactivityTimeoutSeconds, that.accessTokenInactivityTimeoutSeconds)) return false;
    if (!java.util.Objects.equals(accessTokenMaxAgeSeconds, that.accessTokenMaxAgeSeconds)) return false;
    if (!java.util.Objects.equals(additionalSecrets, that.additionalSecrets)) return false;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(grantMethod, that.grantMethod)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;
    if (!java.util.Objects.equals(redirectURIs, that.redirectURIs)) return false;
    if (!java.util.Objects.equals(respondWithChallenges, that.respondWithChallenges)) return false;
    if (!java.util.Objects.equals(scopeRestrictions, that.scopeRestrictions)) return false;
    if (!java.util.Objects.equals(secret, that.secret)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(accessTokenInactivityTimeoutSeconds,  accessTokenMaxAgeSeconds,  additionalSecrets,  apiVersion,  grantMethod,  kind,  metadata,  redirectURIs,  respondWithChallenges,  scopeRestrictions,  secret,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (accessTokenInactivityTimeoutSeconds != null) { sb.append("accessTokenInactivityTimeoutSeconds:"); sb.append(accessTokenInactivityTimeoutSeconds + ","); }
    if (accessTokenMaxAgeSeconds != null) { sb.append("accessTokenMaxAgeSeconds:"); sb.append(accessTokenMaxAgeSeconds + ","); }
    if (additionalSecrets != null && !additionalSecrets.isEmpty()) { sb.append("additionalSecrets:"); sb.append(additionalSecrets + ","); }
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (grantMethod != null) { sb.append("grantMethod:"); sb.append(grantMethod + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (redirectURIs != null && !redirectURIs.isEmpty()) { sb.append("redirectURIs:"); sb.append(redirectURIs + ","); }
    if (respondWithChallenges != null) { sb.append("respondWithChallenges:"); sb.append(respondWithChallenges + ","); }
    if (scopeRestrictions != null && !scopeRestrictions.isEmpty()) { sb.append("scopeRestrictions:"); sb.append(scopeRestrictions + ","); }
    if (secret != null) { sb.append("secret:"); sb.append(secret + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withRespondWithChallenges() {
    return withRespondWithChallenges(true);
  }
  public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    
    public N and() {
      return (N) OAuthClientFluent.this.withMetadata(builder.build());
    }
    
    public N endMetadata() {
      return and();
    }
    
  
  }
  public class ScopeRestrictionsNested<N> extends ScopeRestrictionFluent<ScopeRestrictionsNested<N>> implements Nested<N>{
    ScopeRestrictionsNested(int index,ScopeRestriction item) {
      this.index = index;
      this.builder = new ScopeRestrictionBuilder(this, item);
    }
    ScopeRestrictionBuilder builder;
    int index;
    
    public N and() {
      return (N) OAuthClientFluent.this.setToScopeRestrictions(index,builder.build());
    }
    
    public N endScopeRestriction() {
      return and();
    }
    
  
  }

}