package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NamedClusterRoleBuilder extends NamedClusterRoleFluent<NamedClusterRoleBuilder> implements VisitableBuilder<NamedClusterRole,NamedClusterRoleBuilder>{
  public NamedClusterRoleBuilder() {
    this(new NamedClusterRole());
  }
  
  public NamedClusterRoleBuilder(NamedClusterRoleFluent<?> fluent) {
    this(fluent, new NamedClusterRole());
  }
  
  public NamedClusterRoleBuilder(NamedClusterRoleFluent<?> fluent,NamedClusterRole instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NamedClusterRoleBuilder(NamedClusterRole instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NamedClusterRoleFluent<?> fluent;
  
  public NamedClusterRole build() {
    NamedClusterRole buildable = new NamedClusterRole(fluent.getName(),fluent.buildRole());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}