/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.config.v1.OpenStackPlatformSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class OpenStackPlatformSpecFluent<A extends OpenStackPlatformSpecFluent<A>>
extends BaseFluent<A> {
    private List<String> apiServerInternalIPs = new ArrayList<String>();
    private List<String> ingressIPs = new ArrayList<String>();
    private List<String> machineNetworks = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public OpenStackPlatformSpecFluent() {
    }

    public OpenStackPlatformSpecFluent(OpenStackPlatformSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(OpenStackPlatformSpec instance) {
        OpenStackPlatformSpec openStackPlatformSpec = instance = instance != null ? instance : new OpenStackPlatformSpec();
        if (instance != null) {
            this.withApiServerInternalIPs(instance.getApiServerInternalIPs());
            this.withIngressIPs(instance.getIngressIPs());
            this.withMachineNetworks(instance.getMachineNetworks());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToApiServerInternalIPs(int index, String item) {
        if (this.apiServerInternalIPs == null) {
            this.apiServerInternalIPs = new ArrayList<String>();
        }
        this.apiServerInternalIPs.add(index, item);
        return (A)((Object)this);
    }

    public A setToApiServerInternalIPs(int index, String item) {
        if (this.apiServerInternalIPs == null) {
            this.apiServerInternalIPs = new ArrayList<String>();
        }
        this.apiServerInternalIPs.set(index, item);
        return (A)((Object)this);
    }

    public A addToApiServerInternalIPs(String ... items) {
        if (this.apiServerInternalIPs == null) {
            this.apiServerInternalIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiServerInternalIPs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToApiServerInternalIPs(Collection<String> items) {
        if (this.apiServerInternalIPs == null) {
            this.apiServerInternalIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiServerInternalIPs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromApiServerInternalIPs(String ... items) {
        if (this.apiServerInternalIPs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.apiServerInternalIPs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromApiServerInternalIPs(Collection<String> items) {
        if (this.apiServerInternalIPs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.apiServerInternalIPs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getApiServerInternalIPs() {
        return this.apiServerInternalIPs;
    }

    public String getApiServerInternalIP(int index) {
        return this.apiServerInternalIPs.get(index);
    }

    public String getFirstApiServerInternalIP() {
        return this.apiServerInternalIPs.get(0);
    }

    public String getLastApiServerInternalIP() {
        return this.apiServerInternalIPs.get(this.apiServerInternalIPs.size() - 1);
    }

    public String getMatchingApiServerInternalIP(Predicate<String> predicate) {
        for (String item : this.apiServerInternalIPs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingApiServerInternalIP(Predicate<String> predicate) {
        for (String item : this.apiServerInternalIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withApiServerInternalIPs(List<String> apiServerInternalIPs) {
        if (apiServerInternalIPs != null) {
            this.apiServerInternalIPs = new ArrayList<String>();
            for (String item : apiServerInternalIPs) {
                this.addToApiServerInternalIPs(item);
            }
        } else {
            this.apiServerInternalIPs = null;
        }
        return (A)((Object)this);
    }

    public A withApiServerInternalIPs(String ... apiServerInternalIPs) {
        if (this.apiServerInternalIPs != null) {
            this.apiServerInternalIPs.clear();
            this._visitables.remove((Object)"apiServerInternalIPs");
        }
        if (apiServerInternalIPs != null) {
            for (String item : apiServerInternalIPs) {
                this.addToApiServerInternalIPs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasApiServerInternalIPs() {
        return this.apiServerInternalIPs != null && !this.apiServerInternalIPs.isEmpty();
    }

    public A addToIngressIPs(int index, String item) {
        if (this.ingressIPs == null) {
            this.ingressIPs = new ArrayList<String>();
        }
        this.ingressIPs.add(index, item);
        return (A)((Object)this);
    }

    public A setToIngressIPs(int index, String item) {
        if (this.ingressIPs == null) {
            this.ingressIPs = new ArrayList<String>();
        }
        this.ingressIPs.set(index, item);
        return (A)((Object)this);
    }

    public A addToIngressIPs(String ... items) {
        if (this.ingressIPs == null) {
            this.ingressIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.ingressIPs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToIngressIPs(Collection<String> items) {
        if (this.ingressIPs == null) {
            this.ingressIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.ingressIPs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromIngressIPs(String ... items) {
        if (this.ingressIPs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ingressIPs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIngressIPs(Collection<String> items) {
        if (this.ingressIPs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ingressIPs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getIngressIPs() {
        return this.ingressIPs;
    }

    public String getIngressIP(int index) {
        return this.ingressIPs.get(index);
    }

    public String getFirstIngressIP() {
        return this.ingressIPs.get(0);
    }

    public String getLastIngressIP() {
        return this.ingressIPs.get(this.ingressIPs.size() - 1);
    }

    public String getMatchingIngressIP(Predicate<String> predicate) {
        for (String item : this.ingressIPs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingIngressIP(Predicate<String> predicate) {
        for (String item : this.ingressIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIngressIPs(List<String> ingressIPs) {
        if (ingressIPs != null) {
            this.ingressIPs = new ArrayList<String>();
            for (String item : ingressIPs) {
                this.addToIngressIPs(item);
            }
        } else {
            this.ingressIPs = null;
        }
        return (A)((Object)this);
    }

    public A withIngressIPs(String ... ingressIPs) {
        if (this.ingressIPs != null) {
            this.ingressIPs.clear();
            this._visitables.remove((Object)"ingressIPs");
        }
        if (ingressIPs != null) {
            for (String item : ingressIPs) {
                this.addToIngressIPs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasIngressIPs() {
        return this.ingressIPs != null && !this.ingressIPs.isEmpty();
    }

    public A addToMachineNetworks(int index, String item) {
        if (this.machineNetworks == null) {
            this.machineNetworks = new ArrayList<String>();
        }
        this.machineNetworks.add(index, item);
        return (A)((Object)this);
    }

    public A setToMachineNetworks(int index, String item) {
        if (this.machineNetworks == null) {
            this.machineNetworks = new ArrayList<String>();
        }
        this.machineNetworks.set(index, item);
        return (A)((Object)this);
    }

    public A addToMachineNetworks(String ... items) {
        if (this.machineNetworks == null) {
            this.machineNetworks = new ArrayList<String>();
        }
        for (String item : items) {
            this.machineNetworks.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToMachineNetworks(Collection<String> items) {
        if (this.machineNetworks == null) {
            this.machineNetworks = new ArrayList<String>();
        }
        for (String item : items) {
            this.machineNetworks.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromMachineNetworks(String ... items) {
        if (this.machineNetworks == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.machineNetworks.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMachineNetworks(Collection<String> items) {
        if (this.machineNetworks == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.machineNetworks.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getMachineNetworks() {
        return this.machineNetworks;
    }

    public String getMachineNetwork(int index) {
        return this.machineNetworks.get(index);
    }

    public String getFirstMachineNetwork() {
        return this.machineNetworks.get(0);
    }

    public String getLastMachineNetwork() {
        return this.machineNetworks.get(this.machineNetworks.size() - 1);
    }

    public String getMatchingMachineNetwork(Predicate<String> predicate) {
        for (String item : this.machineNetworks) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingMachineNetwork(Predicate<String> predicate) {
        for (String item : this.machineNetworks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMachineNetworks(List<String> machineNetworks) {
        if (machineNetworks != null) {
            this.machineNetworks = new ArrayList<String>();
            for (String item : machineNetworks) {
                this.addToMachineNetworks(item);
            }
        } else {
            this.machineNetworks = null;
        }
        return (A)((Object)this);
    }

    public A withMachineNetworks(String ... machineNetworks) {
        if (this.machineNetworks != null) {
            this.machineNetworks.clear();
            this._visitables.remove((Object)"machineNetworks");
        }
        if (machineNetworks != null) {
            for (String item : machineNetworks) {
                this.addToMachineNetworks(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasMachineNetworks() {
        return this.machineNetworks != null && !this.machineNetworks.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OpenStackPlatformSpecFluent that = (OpenStackPlatformSpecFluent)((Object)o);
        if (!Objects.equals(this.apiServerInternalIPs, that.apiServerInternalIPs)) {
            return false;
        }
        if (!Objects.equals(this.ingressIPs, that.ingressIPs)) {
            return false;
        }
        if (!Objects.equals(this.machineNetworks, that.machineNetworks)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.apiServerInternalIPs, this.ingressIPs, this.machineNetworks, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiServerInternalIPs != null && !this.apiServerInternalIPs.isEmpty()) {
            sb.append("apiServerInternalIPs:");
            sb.append(this.apiServerInternalIPs + ",");
        }
        if (this.ingressIPs != null && !this.ingressIPs.isEmpty()) {
            sb.append("ingressIPs:");
            sb.append(this.ingressIPs + ",");
        }
        if (this.machineNetworks != null && !this.machineNetworks.isEmpty()) {
            sb.append("machineNetworks:");
            sb.append(this.machineNetworks + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

