/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.AdmissionConfig;
import io.fabric8.openshift.api.model.config.v1.AdmissionConfigBuilder;
import io.fabric8.openshift.api.model.config.v1.AdmissionConfigFluent;
import io.fabric8.openshift.api.model.config.v1.AuditConfig;
import io.fabric8.openshift.api.model.config.v1.AuditConfigBuilder;
import io.fabric8.openshift.api.model.config.v1.AuditConfigFluent;
import io.fabric8.openshift.api.model.config.v1.EtcdStorageConfig;
import io.fabric8.openshift.api.model.config.v1.EtcdStorageConfigBuilder;
import io.fabric8.openshift.api.model.config.v1.EtcdStorageConfigFluent;
import io.fabric8.openshift.api.model.config.v1.GenericAPIServerConfig;
import io.fabric8.openshift.api.model.config.v1.HTTPServingInfo;
import io.fabric8.openshift.api.model.config.v1.HTTPServingInfoBuilder;
import io.fabric8.openshift.api.model.config.v1.HTTPServingInfoFluent;
import io.fabric8.openshift.api.model.config.v1.KubeClientConfig;
import io.fabric8.openshift.api.model.config.v1.KubeClientConfigBuilder;
import io.fabric8.openshift.api.model.config.v1.KubeClientConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class GenericAPIServerConfigFluent<A extends GenericAPIServerConfigFluent<A>>
extends BaseFluent<A> {
    private AdmissionConfigBuilder admission;
    private AuditConfigBuilder auditConfig;
    private List<String> corsAllowedOrigins = new ArrayList<String>();
    private KubeClientConfigBuilder kubeClientConfig;
    private HTTPServingInfoBuilder servingInfo;
    private EtcdStorageConfigBuilder storageConfig;
    private Map<String, Object> additionalProperties;

    public GenericAPIServerConfigFluent() {
    }

    public GenericAPIServerConfigFluent(GenericAPIServerConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GenericAPIServerConfig instance) {
        GenericAPIServerConfig genericAPIServerConfig = instance = instance != null ? instance : new GenericAPIServerConfig();
        if (instance != null) {
            this.withAdmission(instance.getAdmission());
            this.withAuditConfig(instance.getAuditConfig());
            this.withCorsAllowedOrigins(instance.getCorsAllowedOrigins());
            this.withKubeClientConfig(instance.getKubeClientConfig());
            this.withServingInfo(instance.getServingInfo());
            this.withStorageConfig(instance.getStorageConfig());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AdmissionConfig buildAdmission() {
        return this.admission != null ? this.admission.build() : null;
    }

    public A withAdmission(AdmissionConfig admission) {
        this._visitables.remove((Object)"admission");
        if (admission != null) {
            this.admission = new AdmissionConfigBuilder(admission);
            this._visitables.get((Object)"admission").add(this.admission);
        } else {
            this.admission = null;
            this._visitables.get((Object)"admission").remove((Object)this.admission);
        }
        return (A)((Object)this);
    }

    public boolean hasAdmission() {
        return this.admission != null;
    }

    public AdmissionNested<A> withNewAdmission() {
        return new AdmissionNested(null);
    }

    public AdmissionNested<A> withNewAdmissionLike(AdmissionConfig item) {
        return new AdmissionNested(item);
    }

    public AdmissionNested<A> editAdmission() {
        return this.withNewAdmissionLike(Optional.ofNullable(this.buildAdmission()).orElse(null));
    }

    public AdmissionNested<A> editOrNewAdmission() {
        return this.withNewAdmissionLike(Optional.ofNullable(this.buildAdmission()).orElse(new AdmissionConfigBuilder().build()));
    }

    public AdmissionNested<A> editOrNewAdmissionLike(AdmissionConfig item) {
        return this.withNewAdmissionLike(Optional.ofNullable(this.buildAdmission()).orElse(item));
    }

    public AuditConfig buildAuditConfig() {
        return this.auditConfig != null ? this.auditConfig.build() : null;
    }

    public A withAuditConfig(AuditConfig auditConfig) {
        this._visitables.remove((Object)"auditConfig");
        if (auditConfig != null) {
            this.auditConfig = new AuditConfigBuilder(auditConfig);
            this._visitables.get((Object)"auditConfig").add(this.auditConfig);
        } else {
            this.auditConfig = null;
            this._visitables.get((Object)"auditConfig").remove((Object)this.auditConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasAuditConfig() {
        return this.auditConfig != null;
    }

    public AuditConfigNested<A> withNewAuditConfig() {
        return new AuditConfigNested(null);
    }

    public AuditConfigNested<A> withNewAuditConfigLike(AuditConfig item) {
        return new AuditConfigNested(item);
    }

    public AuditConfigNested<A> editAuditConfig() {
        return this.withNewAuditConfigLike(Optional.ofNullable(this.buildAuditConfig()).orElse(null));
    }

    public AuditConfigNested<A> editOrNewAuditConfig() {
        return this.withNewAuditConfigLike(Optional.ofNullable(this.buildAuditConfig()).orElse(new AuditConfigBuilder().build()));
    }

    public AuditConfigNested<A> editOrNewAuditConfigLike(AuditConfig item) {
        return this.withNewAuditConfigLike(Optional.ofNullable(this.buildAuditConfig()).orElse(item));
    }

    public A addToCorsAllowedOrigins(int index, String item) {
        if (this.corsAllowedOrigins == null) {
            this.corsAllowedOrigins = new ArrayList<String>();
        }
        this.corsAllowedOrigins.add(index, item);
        return (A)((Object)this);
    }

    public A setToCorsAllowedOrigins(int index, String item) {
        if (this.corsAllowedOrigins == null) {
            this.corsAllowedOrigins = new ArrayList<String>();
        }
        this.corsAllowedOrigins.set(index, item);
        return (A)((Object)this);
    }

    public A addToCorsAllowedOrigins(String ... items) {
        if (this.corsAllowedOrigins == null) {
            this.corsAllowedOrigins = new ArrayList<String>();
        }
        for (String item : items) {
            this.corsAllowedOrigins.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCorsAllowedOrigins(Collection<String> items) {
        if (this.corsAllowedOrigins == null) {
            this.corsAllowedOrigins = new ArrayList<String>();
        }
        for (String item : items) {
            this.corsAllowedOrigins.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCorsAllowedOrigins(String ... items) {
        if (this.corsAllowedOrigins == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.corsAllowedOrigins.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCorsAllowedOrigins(Collection<String> items) {
        if (this.corsAllowedOrigins == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.corsAllowedOrigins.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getCorsAllowedOrigins() {
        return this.corsAllowedOrigins;
    }

    public String getCorsAllowedOrigin(int index) {
        return this.corsAllowedOrigins.get(index);
    }

    public String getFirstCorsAllowedOrigin() {
        return this.corsAllowedOrigins.get(0);
    }

    public String getLastCorsAllowedOrigin() {
        return this.corsAllowedOrigins.get(this.corsAllowedOrigins.size() - 1);
    }

    public String getMatchingCorsAllowedOrigin(Predicate<String> predicate) {
        for (String item : this.corsAllowedOrigins) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCorsAllowedOrigin(Predicate<String> predicate) {
        for (String item : this.corsAllowedOrigins) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCorsAllowedOrigins(List<String> corsAllowedOrigins) {
        if (corsAllowedOrigins != null) {
            this.corsAllowedOrigins = new ArrayList<String>();
            for (String item : corsAllowedOrigins) {
                this.addToCorsAllowedOrigins(item);
            }
        } else {
            this.corsAllowedOrigins = null;
        }
        return (A)((Object)this);
    }

    public A withCorsAllowedOrigins(String ... corsAllowedOrigins) {
        if (this.corsAllowedOrigins != null) {
            this.corsAllowedOrigins.clear();
            this._visitables.remove((Object)"corsAllowedOrigins");
        }
        if (corsAllowedOrigins != null) {
            for (String item : corsAllowedOrigins) {
                this.addToCorsAllowedOrigins(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCorsAllowedOrigins() {
        return this.corsAllowedOrigins != null && !this.corsAllowedOrigins.isEmpty();
    }

    public KubeClientConfig buildKubeClientConfig() {
        return this.kubeClientConfig != null ? this.kubeClientConfig.build() : null;
    }

    public A withKubeClientConfig(KubeClientConfig kubeClientConfig) {
        this._visitables.remove((Object)"kubeClientConfig");
        if (kubeClientConfig != null) {
            this.kubeClientConfig = new KubeClientConfigBuilder(kubeClientConfig);
            this._visitables.get((Object)"kubeClientConfig").add(this.kubeClientConfig);
        } else {
            this.kubeClientConfig = null;
            this._visitables.get((Object)"kubeClientConfig").remove((Object)this.kubeClientConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasKubeClientConfig() {
        return this.kubeClientConfig != null;
    }

    public KubeClientConfigNested<A> withNewKubeClientConfig() {
        return new KubeClientConfigNested(null);
    }

    public KubeClientConfigNested<A> withNewKubeClientConfigLike(KubeClientConfig item) {
        return new KubeClientConfigNested(item);
    }

    public KubeClientConfigNested<A> editKubeClientConfig() {
        return this.withNewKubeClientConfigLike(Optional.ofNullable(this.buildKubeClientConfig()).orElse(null));
    }

    public KubeClientConfigNested<A> editOrNewKubeClientConfig() {
        return this.withNewKubeClientConfigLike(Optional.ofNullable(this.buildKubeClientConfig()).orElse(new KubeClientConfigBuilder().build()));
    }

    public KubeClientConfigNested<A> editOrNewKubeClientConfigLike(KubeClientConfig item) {
        return this.withNewKubeClientConfigLike(Optional.ofNullable(this.buildKubeClientConfig()).orElse(item));
    }

    public HTTPServingInfo buildServingInfo() {
        return this.servingInfo != null ? this.servingInfo.build() : null;
    }

    public A withServingInfo(HTTPServingInfo servingInfo) {
        this._visitables.remove((Object)"servingInfo");
        if (servingInfo != null) {
            this.servingInfo = new HTTPServingInfoBuilder(servingInfo);
            this._visitables.get((Object)"servingInfo").add(this.servingInfo);
        } else {
            this.servingInfo = null;
            this._visitables.get((Object)"servingInfo").remove((Object)this.servingInfo);
        }
        return (A)((Object)this);
    }

    public boolean hasServingInfo() {
        return this.servingInfo != null;
    }

    public ServingInfoNested<A> withNewServingInfo() {
        return new ServingInfoNested(null);
    }

    public ServingInfoNested<A> withNewServingInfoLike(HTTPServingInfo item) {
        return new ServingInfoNested(item);
    }

    public ServingInfoNested<A> editServingInfo() {
        return this.withNewServingInfoLike(Optional.ofNullable(this.buildServingInfo()).orElse(null));
    }

    public ServingInfoNested<A> editOrNewServingInfo() {
        return this.withNewServingInfoLike(Optional.ofNullable(this.buildServingInfo()).orElse(new HTTPServingInfoBuilder().build()));
    }

    public ServingInfoNested<A> editOrNewServingInfoLike(HTTPServingInfo item) {
        return this.withNewServingInfoLike(Optional.ofNullable(this.buildServingInfo()).orElse(item));
    }

    public EtcdStorageConfig buildStorageConfig() {
        return this.storageConfig != null ? this.storageConfig.build() : null;
    }

    public A withStorageConfig(EtcdStorageConfig storageConfig) {
        this._visitables.remove((Object)"storageConfig");
        if (storageConfig != null) {
            this.storageConfig = new EtcdStorageConfigBuilder(storageConfig);
            this._visitables.get((Object)"storageConfig").add(this.storageConfig);
        } else {
            this.storageConfig = null;
            this._visitables.get((Object)"storageConfig").remove((Object)this.storageConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasStorageConfig() {
        return this.storageConfig != null;
    }

    public StorageConfigNested<A> withNewStorageConfig() {
        return new StorageConfigNested(null);
    }

    public StorageConfigNested<A> withNewStorageConfigLike(EtcdStorageConfig item) {
        return new StorageConfigNested(item);
    }

    public StorageConfigNested<A> editStorageConfig() {
        return this.withNewStorageConfigLike(Optional.ofNullable(this.buildStorageConfig()).orElse(null));
    }

    public StorageConfigNested<A> editOrNewStorageConfig() {
        return this.withNewStorageConfigLike(Optional.ofNullable(this.buildStorageConfig()).orElse(new EtcdStorageConfigBuilder().build()));
    }

    public StorageConfigNested<A> editOrNewStorageConfigLike(EtcdStorageConfig item) {
        return this.withNewStorageConfigLike(Optional.ofNullable(this.buildStorageConfig()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GenericAPIServerConfigFluent that = (GenericAPIServerConfigFluent)((Object)o);
        if (!Objects.equals((Object)this.admission, (Object)that.admission)) {
            return false;
        }
        if (!Objects.equals((Object)this.auditConfig, (Object)that.auditConfig)) {
            return false;
        }
        if (!Objects.equals(this.corsAllowedOrigins, that.corsAllowedOrigins)) {
            return false;
        }
        if (!Objects.equals((Object)this.kubeClientConfig, (Object)that.kubeClientConfig)) {
            return false;
        }
        if (!Objects.equals((Object)this.servingInfo, (Object)that.servingInfo)) {
            return false;
        }
        if (!Objects.equals((Object)this.storageConfig, (Object)that.storageConfig)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.admission, this.auditConfig, this.corsAllowedOrigins, this.kubeClientConfig, this.servingInfo, this.storageConfig, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.admission != null) {
            sb.append("admission:");
            sb.append(this.admission + ",");
        }
        if (this.auditConfig != null) {
            sb.append("auditConfig:");
            sb.append(this.auditConfig + ",");
        }
        if (this.corsAllowedOrigins != null && !this.corsAllowedOrigins.isEmpty()) {
            sb.append("corsAllowedOrigins:");
            sb.append(this.corsAllowedOrigins + ",");
        }
        if (this.kubeClientConfig != null) {
            sb.append("kubeClientConfig:");
            sb.append(this.kubeClientConfig + ",");
        }
        if (this.servingInfo != null) {
            sb.append("servingInfo:");
            sb.append(this.servingInfo + ",");
        }
        if (this.storageConfig != null) {
            sb.append("storageConfig:");
            sb.append(this.storageConfig + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class StorageConfigNested<N>
    extends EtcdStorageConfigFluent<StorageConfigNested<N>>
    implements Nested<N> {
        EtcdStorageConfigBuilder builder;

        StorageConfigNested(EtcdStorageConfig item) {
            this.builder = new EtcdStorageConfigBuilder(this, item);
        }

        public N and() {
            return (N)GenericAPIServerConfigFluent.this.withStorageConfig(this.builder.build());
        }

        public N endStorageConfig() {
            return this.and();
        }
    }

    public class ServingInfoNested<N>
    extends HTTPServingInfoFluent<ServingInfoNested<N>>
    implements Nested<N> {
        HTTPServingInfoBuilder builder;

        ServingInfoNested(HTTPServingInfo item) {
            this.builder = new HTTPServingInfoBuilder(this, item);
        }

        public N and() {
            return (N)GenericAPIServerConfigFluent.this.withServingInfo(this.builder.build());
        }

        public N endServingInfo() {
            return this.and();
        }
    }

    public class KubeClientConfigNested<N>
    extends KubeClientConfigFluent<KubeClientConfigNested<N>>
    implements Nested<N> {
        KubeClientConfigBuilder builder;

        KubeClientConfigNested(KubeClientConfig item) {
            this.builder = new KubeClientConfigBuilder(this, item);
        }

        public N and() {
            return (N)GenericAPIServerConfigFluent.this.withKubeClientConfig(this.builder.build());
        }

        public N endKubeClientConfig() {
            return this.and();
        }
    }

    public class AuditConfigNested<N>
    extends AuditConfigFluent<AuditConfigNested<N>>
    implements Nested<N> {
        AuditConfigBuilder builder;

        AuditConfigNested(AuditConfig item) {
            this.builder = new AuditConfigBuilder(this, item);
        }

        public N and() {
            return (N)GenericAPIServerConfigFluent.this.withAuditConfig(this.builder.build());
        }

        public N endAuditConfig() {
            return this.and();
        }
    }

    public class AdmissionNested<N>
    extends AdmissionConfigFluent<AdmissionNested<N>>
    implements Nested<N> {
        AdmissionConfigBuilder builder;

        AdmissionNested(AdmissionConfig item) {
            this.builder = new AdmissionConfigBuilder(this, item);
        }

        public N and() {
            return (N)GenericAPIServerConfigFluent.this.withAdmission(this.builder.build());
        }

        public N endAdmission() {
            return this.and();
        }
    }
}

