/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.openshift.api.model.GitInfoBuilder;
import io.fabric8.openshift.api.model.GitRefInfo;
import io.fabric8.openshift.api.model.SourceControlUser;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonDeserialize(using=JsonDeserializer.None.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"author", "commit", "committer", "httpProxy", "httpsProxy", "message", "noProxy", "ref", "refs", "uri"})
public class GitInfo
implements Editable<GitInfoBuilder>,
KubernetesResource {
    @JsonProperty(value="author")
    private SourceControlUser author;
    @JsonProperty(value="commit")
    private String commit;
    @JsonProperty(value="committer")
    private SourceControlUser committer;
    @JsonProperty(value="httpProxy")
    private String httpProxy;
    @JsonProperty(value="httpsProxy")
    private String httpsProxy;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="noProxy")
    private String noProxy;
    @JsonProperty(value="ref")
    private String ref;
    @JsonProperty(value="refs")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<GitRefInfo> refs = new ArrayList<GitRefInfo>();
    @JsonProperty(value="uri")
    private String uri;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    public GitInfo() {
    }

    public GitInfo(SourceControlUser author, String commit, SourceControlUser committer, String httpProxy, String httpsProxy, String message, String noProxy, String ref, List<GitRefInfo> refs, String uri) {
        this.author = author;
        this.commit = commit;
        this.committer = committer;
        this.httpProxy = httpProxy;
        this.httpsProxy = httpsProxy;
        this.message = message;
        this.noProxy = noProxy;
        this.ref = ref;
        this.refs = refs;
        this.uri = uri;
    }

    @JsonProperty(value="author")
    public SourceControlUser getAuthor() {
        return this.author;
    }

    @JsonProperty(value="author")
    public void setAuthor(SourceControlUser author) {
        this.author = author;
    }

    @JsonProperty(value="commit")
    public String getCommit() {
        return this.commit;
    }

    @JsonProperty(value="commit")
    public void setCommit(String commit) {
        this.commit = commit;
    }

    @JsonProperty(value="committer")
    public SourceControlUser getCommitter() {
        return this.committer;
    }

    @JsonProperty(value="committer")
    public void setCommitter(SourceControlUser committer) {
        this.committer = committer;
    }

    @JsonProperty(value="httpProxy")
    public String getHttpProxy() {
        return this.httpProxy;
    }

    @JsonProperty(value="httpProxy")
    public void setHttpProxy(String httpProxy) {
        this.httpProxy = httpProxy;
    }

    @JsonProperty(value="httpsProxy")
    public String getHttpsProxy() {
        return this.httpsProxy;
    }

    @JsonProperty(value="httpsProxy")
    public void setHttpsProxy(String httpsProxy) {
        this.httpsProxy = httpsProxy;
    }

    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    public void setMessage(String message) {
        this.message = message;
    }

    @JsonProperty(value="noProxy")
    public String getNoProxy() {
        return this.noProxy;
    }

    @JsonProperty(value="noProxy")
    public void setNoProxy(String noProxy) {
        this.noProxy = noProxy;
    }

    @JsonProperty(value="ref")
    public String getRef() {
        return this.ref;
    }

    @JsonProperty(value="ref")
    public void setRef(String ref) {
        this.ref = ref;
    }

    @JsonProperty(value="refs")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<GitRefInfo> getRefs() {
        return this.refs;
    }

    @JsonProperty(value="refs")
    public void setRefs(List<GitRefInfo> refs) {
        this.refs = refs;
    }

    @JsonProperty(value="uri")
    public String getUri() {
        return this.uri;
    }

    @JsonProperty(value="uri")
    public void setUri(String uri) {
        this.uri = uri;
    }

    @JsonIgnore
    public GitInfoBuilder edit() {
        return new GitInfoBuilder(this);
    }

    @JsonIgnore
    public GitInfoBuilder toBuilder() {
        return this.edit();
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    @Generated
    public String toString() {
        return "GitInfo(author=" + this.getAuthor() + ", commit=" + this.getCommit() + ", committer=" + this.getCommitter() + ", httpProxy=" + this.getHttpProxy() + ", httpsProxy=" + this.getHttpsProxy() + ", message=" + this.getMessage() + ", noProxy=" + this.getNoProxy() + ", ref=" + this.getRef() + ", refs=" + this.getRefs() + ", uri=" + this.getUri() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitInfo)) {
            return false;
        }
        GitInfo other = (GitInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SourceControlUser this$author = this.getAuthor();
        SourceControlUser other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !((Object)this$author).equals(other$author)) {
            return false;
        }
        String this$commit = this.getCommit();
        String other$commit = other.getCommit();
        if (this$commit == null ? other$commit != null : !this$commit.equals(other$commit)) {
            return false;
        }
        SourceControlUser this$committer = this.getCommitter();
        SourceControlUser other$committer = other.getCommitter();
        if (this$committer == null ? other$committer != null : !((Object)this$committer).equals(other$committer)) {
            return false;
        }
        String this$httpProxy = this.getHttpProxy();
        String other$httpProxy = other.getHttpProxy();
        if (this$httpProxy == null ? other$httpProxy != null : !this$httpProxy.equals(other$httpProxy)) {
            return false;
        }
        String this$httpsProxy = this.getHttpsProxy();
        String other$httpsProxy = other.getHttpsProxy();
        if (this$httpsProxy == null ? other$httpsProxy != null : !this$httpsProxy.equals(other$httpsProxy)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$noProxy = this.getNoProxy();
        String other$noProxy = other.getNoProxy();
        if (this$noProxy == null ? other$noProxy != null : !this$noProxy.equals(other$noProxy)) {
            return false;
        }
        String this$ref = this.getRef();
        String other$ref = other.getRef();
        if (this$ref == null ? other$ref != null : !this$ref.equals(other$ref)) {
            return false;
        }
        List<GitRefInfo> this$refs = this.getRefs();
        List<GitRefInfo> other$refs = other.getRefs();
        if (this$refs == null ? other$refs != null : !((Object)this$refs).equals(other$refs)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GitInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SourceControlUser $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : ((Object)$author).hashCode());
        String $commit = this.getCommit();
        result = result * 59 + ($commit == null ? 43 : $commit.hashCode());
        SourceControlUser $committer = this.getCommitter();
        result = result * 59 + ($committer == null ? 43 : ((Object)$committer).hashCode());
        String $httpProxy = this.getHttpProxy();
        result = result * 59 + ($httpProxy == null ? 43 : $httpProxy.hashCode());
        String $httpsProxy = this.getHttpsProxy();
        result = result * 59 + ($httpsProxy == null ? 43 : $httpsProxy.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $noProxy = this.getNoProxy();
        result = result * 59 + ($noProxy == null ? 43 : $noProxy.hashCode());
        String $ref = this.getRef();
        result = result * 59 + ($ref == null ? 43 : $ref.hashCode());
        List<GitRefInfo> $refs = this.getRefs();
        result = result * 59 + ($refs == null ? 43 : ((Object)$refs).hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

