package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TemplateInstanceObjectBuilder extends TemplateInstanceObjectFluent<TemplateInstanceObjectBuilder> implements VisitableBuilder<TemplateInstanceObject,TemplateInstanceObjectBuilder>{
  public TemplateInstanceObjectBuilder() {
    this(new TemplateInstanceObject());
  }
  
  public TemplateInstanceObjectBuilder(TemplateInstanceObjectFluent<?> fluent) {
    this(fluent, new TemplateInstanceObject());
  }
  
  public TemplateInstanceObjectBuilder(TemplateInstanceObjectFluent<?> fluent,TemplateInstanceObject instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TemplateInstanceObjectBuilder(TemplateInstanceObject instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TemplateInstanceObjectFluent<?> fluent;
  
  public TemplateInstanceObject build() {
    TemplateInstanceObject buildable = new TemplateInstanceObject(fluent.buildRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}