package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ImageStreamImportBuilder extends ImageStreamImportFluent<ImageStreamImportBuilder> implements VisitableBuilder<ImageStreamImport,ImageStreamImportBuilder>{
  public ImageStreamImportBuilder() {
    this(new ImageStreamImport());
  }
  
  public ImageStreamImportBuilder(ImageStreamImportFluent<?> fluent) {
    this(fluent, new ImageStreamImport());
  }
  
  public ImageStreamImportBuilder(ImageStreamImportFluent<?> fluent,ImageStreamImport instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ImageStreamImportBuilder(ImageStreamImport instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ImageStreamImportFluent<?> fluent;
  
  public ImageStreamImport build() {
    ImageStreamImport buildable = new ImageStreamImport(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}