/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigFluentImpl;

public class BuildConfigBuilder
extends BuildConfigFluentImpl<BuildConfigBuilder>
implements VisitableBuilder<BuildConfig, BuildConfigBuilder> {
    BuildConfigFluent<?> fluent;
    Boolean validationEnabled;

    public BuildConfigBuilder() {
        this(false);
    }

    public BuildConfigBuilder(Boolean validationEnabled) {
        this(new BuildConfig(), validationEnabled);
    }

    public BuildConfigBuilder(BuildConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public BuildConfigBuilder(BuildConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BuildConfig(), validationEnabled);
    }

    public BuildConfigBuilder(BuildConfigFluent<?> fluent, BuildConfig instance) {
        this(fluent, instance, false);
    }

    public BuildConfigBuilder(BuildConfigFluent<?> fluent, BuildConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public BuildConfigBuilder(BuildConfig instance) {
        this(instance, (Boolean)false);
    }

    public BuildConfigBuilder(BuildConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public BuildConfig build() {
        BuildConfig buildable = new BuildConfig(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

