/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.BuildVolume;
import io.fabric8.openshift.api.model.BuildVolumeBuilder;
import io.fabric8.openshift.api.model.BuildVolumeFluentImpl;
import io.fabric8.openshift.api.model.DockerBuildStrategy;
import io.fabric8.openshift.api.model.DockerBuildStrategyFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DockerBuildStrategyFluentImpl<A extends DockerBuildStrategyFluent<A>>
extends BaseFluent<A>
implements DockerBuildStrategyFluent<A> {
    private List<EnvVar> buildArgs = new ArrayList<EnvVar>();
    private String dockerfilePath;
    private List<EnvVar> env = new ArrayList<EnvVar>();
    private Boolean forcePull;
    private ObjectReferenceBuilder from;
    private String imageOptimizationPolicy;
    private Boolean noCache;
    private LocalObjectReferenceBuilder pullSecret;
    private ArrayList<BuildVolumeBuilder> volumes = new ArrayList();
    private Map<String, Object> additionalProperties;

    public DockerBuildStrategyFluentImpl() {
    }

    public DockerBuildStrategyFluentImpl(DockerBuildStrategy instance) {
        this.withBuildArgs(instance.getBuildArgs());
        this.withDockerfilePath(instance.getDockerfilePath());
        this.withEnv(instance.getEnv());
        this.withForcePull(instance.getForcePull());
        this.withFrom(instance.getFrom());
        this.withImageOptimizationPolicy(instance.getImageOptimizationPolicy());
        this.withNoCache(instance.getNoCache());
        this.withPullSecret(instance.getPullSecret());
        this.withVolumes(instance.getVolumes());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToBuildArgs(Integer index, EnvVar item) {
        if (this.buildArgs == null) {
            this.buildArgs = new ArrayList<EnvVar>();
        }
        this.buildArgs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToBuildArgs(Integer index, EnvVar item) {
        if (this.buildArgs == null) {
            this.buildArgs = new ArrayList<EnvVar>();
        }
        this.buildArgs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToBuildArgs(EnvVar ... items) {
        if (this.buildArgs == null) {
            this.buildArgs = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.buildArgs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToBuildArgs(Collection<EnvVar> items) {
        if (this.buildArgs == null) {
            this.buildArgs = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.buildArgs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromBuildArgs(EnvVar ... items) {
        for (EnvVar item : items) {
            if (this.buildArgs == null) continue;
            this.buildArgs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromBuildArgs(Collection<EnvVar> items) {
        for (EnvVar item : items) {
            if (this.buildArgs == null) continue;
            this.buildArgs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<EnvVar> getBuildArgs() {
        return this.buildArgs;
    }

    @Override
    public EnvVar getBuildArg(Integer index) {
        return this.buildArgs.get(index);
    }

    @Override
    public EnvVar getFirstBuildArg() {
        return this.buildArgs.get(0);
    }

    @Override
    public EnvVar getLastBuildArg() {
        return this.buildArgs.get(this.buildArgs.size() - 1);
    }

    @Override
    public EnvVar getMatchingBuildArg(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.buildArgs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingBuildArg(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.buildArgs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withBuildArgs(List<EnvVar> buildArgs) {
        if (buildArgs != null) {
            this.buildArgs = new ArrayList<EnvVar>();
            for (EnvVar item : buildArgs) {
                this.addToBuildArgs(item);
            }
        } else {
            this.buildArgs = null;
        }
        return (A)this;
    }

    @Override
    public A withBuildArgs(EnvVar ... buildArgs) {
        if (this.buildArgs != null) {
            this.buildArgs.clear();
        }
        if (buildArgs != null) {
            for (EnvVar item : buildArgs) {
                this.addToBuildArgs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasBuildArgs() {
        return this.buildArgs != null && !this.buildArgs.isEmpty();
    }

    @Override
    public String getDockerfilePath() {
        return this.dockerfilePath;
    }

    @Override
    public A withDockerfilePath(String dockerfilePath) {
        this.dockerfilePath = dockerfilePath;
        return (A)this;
    }

    @Override
    public Boolean hasDockerfilePath() {
        return this.dockerfilePath != null;
    }

    @Override
    public A addToEnv(Integer index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        this.env.add(index, item);
        return (A)this;
    }

    @Override
    public A setToEnv(Integer index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        this.env.set(index, item);
        return (A)this;
    }

    @Override
    public A addToEnv(EnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.env.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.env.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            if (this.env == null) continue;
            this.env.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnv(Collection<EnvVar> items) {
        for (EnvVar item : items) {
            if (this.env == null) continue;
            this.env.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<EnvVar> getEnv() {
        return this.env;
    }

    @Override
    public EnvVar getEnv(Integer index) {
        return this.env.get(index);
    }

    @Override
    public EnvVar getFirstEnv() {
        return this.env.get(0);
    }

    @Override
    public EnvVar getLastEnv() {
        return this.env.get(this.env.size() - 1);
    }

    @Override
    public EnvVar getMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.env) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEnv(List<EnvVar> env) {
        if (env != null) {
            this.env = new ArrayList<EnvVar>();
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)this;
    }

    @Override
    public A withEnv(EnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
        }
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    @Override
    public Boolean getForcePull() {
        return this.forcePull;
    }

    @Override
    public A withForcePull(Boolean forcePull) {
        this.forcePull = forcePull;
        return (A)this;
    }

    @Override
    public Boolean hasForcePull() {
        return this.forcePull != null;
    }

    @Override
    @Deprecated
    public ObjectReference getFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public ObjectReference buildFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public A withFrom(ObjectReference from) {
        this._visitables.get((Object)"from").remove(this.from);
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.get((Object)"from").add(this.from);
        } else {
            this.from = null;
            this._visitables.get((Object)"from").remove(this.from);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFrom() {
        return this.from != null;
    }

    @Override
    public DockerBuildStrategyFluent.FromNested<A> withNewFrom() {
        return new FromNestedImpl();
    }

    @Override
    public DockerBuildStrategyFluent.FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNestedImpl(item);
    }

    @Override
    public DockerBuildStrategyFluent.FromNested<A> editFrom() {
        return this.withNewFromLike(this.getFrom());
    }

    @Override
    public DockerBuildStrategyFluent.FromNested<A> editOrNewFrom() {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : new ObjectReferenceBuilder().build());
    }

    @Override
    public DockerBuildStrategyFluent.FromNested<A> editOrNewFromLike(ObjectReference item) {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : item);
    }

    @Override
    public String getImageOptimizationPolicy() {
        return this.imageOptimizationPolicy;
    }

    @Override
    public A withImageOptimizationPolicy(String imageOptimizationPolicy) {
        this.imageOptimizationPolicy = imageOptimizationPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasImageOptimizationPolicy() {
        return this.imageOptimizationPolicy != null;
    }

    @Override
    public Boolean getNoCache() {
        return this.noCache;
    }

    @Override
    public A withNoCache(Boolean noCache) {
        this.noCache = noCache;
        return (A)this;
    }

    @Override
    public Boolean hasNoCache() {
        return this.noCache != null;
    }

    @Override
    @Deprecated
    public LocalObjectReference getPullSecret() {
        return this.pullSecret != null ? this.pullSecret.build() : null;
    }

    @Override
    public LocalObjectReference buildPullSecret() {
        return this.pullSecret != null ? this.pullSecret.build() : null;
    }

    @Override
    public A withPullSecret(LocalObjectReference pullSecret) {
        this._visitables.get((Object)"pullSecret").remove(this.pullSecret);
        if (pullSecret != null) {
            this.pullSecret = new LocalObjectReferenceBuilder(pullSecret);
            this._visitables.get((Object)"pullSecret").add(this.pullSecret);
        } else {
            this.pullSecret = null;
            this._visitables.get((Object)"pullSecret").remove(this.pullSecret);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPullSecret() {
        return this.pullSecret != null;
    }

    @Override
    public A withNewPullSecret(String name) {
        return this.withPullSecret(new LocalObjectReference(name));
    }

    @Override
    public DockerBuildStrategyFluent.PullSecretNested<A> withNewPullSecret() {
        return new PullSecretNestedImpl();
    }

    @Override
    public DockerBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item) {
        return new PullSecretNestedImpl(item);
    }

    @Override
    public DockerBuildStrategyFluent.PullSecretNested<A> editPullSecret() {
        return this.withNewPullSecretLike(this.getPullSecret());
    }

    @Override
    public DockerBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecret() {
        return this.withNewPullSecretLike(this.getPullSecret() != null ? this.getPullSecret() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public DockerBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item) {
        return this.withNewPullSecretLike(this.getPullSecret() != null ? this.getPullSecret() : item);
    }

    @Override
    public A addToVolumes(Integer index, BuildVolume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        BuildVolumeBuilder builder = new BuildVolumeBuilder(item);
        this._visitables.get((Object)"volumes").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"volumes").size(), builder);
        this.volumes.add(index >= 0 ? index.intValue() : this.volumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVolumes(Integer index, BuildVolume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        BuildVolumeBuilder builder = new BuildVolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"volumes").size()) {
            this._visitables.get((Object)"volumes").add(builder);
        } else {
            this._visitables.get((Object)"volumes").set(index, builder);
        }
        if (index < 0 || index >= this.volumes.size()) {
            this.volumes.add(builder);
        } else {
            this.volumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumes(BuildVolume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (BuildVolume item : items) {
            BuildVolumeBuilder builder = new BuildVolumeBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<BuildVolume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (BuildVolume item : items) {
            BuildVolumeBuilder builder = new BuildVolumeBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(BuildVolume ... items) {
        for (BuildVolume item : items) {
            BuildVolumeBuilder builder = new BuildVolumeBuilder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<BuildVolume> items) {
        for (BuildVolume item : items) {
            BuildVolumeBuilder builder = new BuildVolumeBuilder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromVolumes(Predicate<BuildVolumeBuilder> predicate) {
        if (this.volumes == null) {
            return (A)this;
        }
        Iterator<BuildVolumeBuilder> each = this.volumes.iterator();
        List visitables = this._visitables.get((Object)"volumes");
        while (each.hasNext()) {
            BuildVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<BuildVolume> getVolumes() {
        return this.volumes != null ? DockerBuildStrategyFluentImpl.build(this.volumes) : null;
    }

    @Override
    public List<BuildVolume> buildVolumes() {
        return this.volumes != null ? DockerBuildStrategyFluentImpl.build(this.volumes) : null;
    }

    @Override
    public BuildVolume buildVolume(Integer index) {
        return this.volumes.get(index).build();
    }

    @Override
    public BuildVolume buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    @Override
    public BuildVolume buildLastVolume() {
        return this.volumes.get(this.volumes.size() - 1).build();
    }

    @Override
    public BuildVolume buildMatchingVolume(Predicate<BuildVolumeBuilder> predicate) {
        for (BuildVolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolume(Predicate<BuildVolumeBuilder> predicate) {
        for (BuildVolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumes(List<BuildVolume> volumes) {
        if (this.volumes != null) {
            this._visitables.get((Object)"volumes").removeAll(this.volumes);
        }
        if (volumes != null) {
            this.volumes = new ArrayList();
            for (BuildVolume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumes(BuildVolume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
        }
        if (volumes != null) {
            for (BuildVolume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    @Override
    public DockerBuildStrategyFluent.VolumesNested<A> addNewVolume() {
        return new VolumesNestedImpl();
    }

    @Override
    public DockerBuildStrategyFluent.VolumesNested<A> addNewVolumeLike(BuildVolume item) {
        return new VolumesNestedImpl(-1, item);
    }

    @Override
    public DockerBuildStrategyFluent.VolumesNested<A> setNewVolumeLike(Integer index, BuildVolume item) {
        return new VolumesNestedImpl(index, item);
    }

    @Override
    public DockerBuildStrategyFluent.VolumesNested<A> editVolume(Integer index) {
        if (this.volumes.size() <= index) {
            throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public DockerBuildStrategyFluent.VolumesNested<A> editFirstVolume() {
        if (this.volumes.size() == 0) {
            throw new RuntimeException("Can't edit first volumes. The list is empty.");
        }
        return this.setNewVolumeLike(0, this.buildVolume(0));
    }

    @Override
    public DockerBuildStrategyFluent.VolumesNested<A> editLastVolume() {
        int index = this.volumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumes. The list is empty.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public DockerBuildStrategyFluent.VolumesNested<A> editMatchingVolume(Predicate<BuildVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumes.size(); ++i) {
            if (!predicate.test(this.volumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumes. No match found.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerBuildStrategyFluentImpl that = (DockerBuildStrategyFluentImpl)o;
        if (this.buildArgs != null ? !this.buildArgs.equals(that.buildArgs) : that.buildArgs != null) {
            return false;
        }
        if (this.dockerfilePath != null ? !this.dockerfilePath.equals(that.dockerfilePath) : that.dockerfilePath != null) {
            return false;
        }
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        if (this.forcePull != null ? !this.forcePull.equals(that.forcePull) : that.forcePull != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals((Object)that.from) : that.from != null) {
            return false;
        }
        if (this.imageOptimizationPolicy != null ? !this.imageOptimizationPolicy.equals(that.imageOptimizationPolicy) : that.imageOptimizationPolicy != null) {
            return false;
        }
        if (this.noCache != null ? !this.noCache.equals(that.noCache) : that.noCache != null) {
            return false;
        }
        if (this.pullSecret != null ? !this.pullSecret.equals((Object)that.pullSecret) : that.pullSecret != null) {
            return false;
        }
        if (this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.buildArgs, this.dockerfilePath, this.env, this.forcePull, this.from, this.imageOptimizationPolicy, this.noCache, this.pullSecret, this.volumes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.buildArgs != null && !this.buildArgs.isEmpty()) {
            sb.append("buildArgs:");
            sb.append(this.buildArgs + ",");
        }
        if (this.dockerfilePath != null) {
            sb.append("dockerfilePath:");
            sb.append(this.dockerfilePath + ",");
        }
        if (this.env != null && !this.env.isEmpty()) {
            sb.append("env:");
            sb.append(this.env + ",");
        }
        if (this.forcePull != null) {
            sb.append("forcePull:");
            sb.append(this.forcePull + ",");
        }
        if (this.from != null) {
            sb.append("from:");
            sb.append(this.from + ",");
        }
        if (this.imageOptimizationPolicy != null) {
            sb.append("imageOptimizationPolicy:");
            sb.append(this.imageOptimizationPolicy + ",");
        }
        if (this.noCache != null) {
            sb.append("noCache:");
            sb.append(this.noCache + ",");
        }
        if (this.pullSecret != null) {
            sb.append("pullSecret:");
            sb.append(this.pullSecret + ",");
        }
        if (this.volumes != null && !this.volumes.isEmpty()) {
            sb.append("volumes:");
            sb.append(this.volumes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withForcePull() {
        return this.withForcePull(true);
    }

    @Override
    public A withNoCache() {
        return this.withNoCache(true);
    }

    class VolumesNestedImpl<N>
    extends BuildVolumeFluentImpl<DockerBuildStrategyFluent.VolumesNested<N>>
    implements DockerBuildStrategyFluent.VolumesNested<N>,
    Nested<N> {
        BuildVolumeBuilder builder;
        Integer index;

        VolumesNestedImpl(Integer index, BuildVolume item) {
            this.index = index;
            this.builder = new BuildVolumeBuilder(this, item);
        }

        VolumesNestedImpl() {
            this.index = -1;
            this.builder = new BuildVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)DockerBuildStrategyFluentImpl.this.setToVolumes(this.index, this.builder.build());
        }

        @Override
        public N endVolume() {
            return this.and();
        }
    }

    class PullSecretNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<DockerBuildStrategyFluent.PullSecretNested<N>>
    implements DockerBuildStrategyFluent.PullSecretNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;

        PullSecretNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        PullSecretNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this);
        }

        @Override
        public N and() {
            return (N)DockerBuildStrategyFluentImpl.this.withPullSecret(this.builder.build());
        }

        @Override
        public N endPullSecret() {
            return this.and();
        }
    }

    class FromNestedImpl<N>
    extends ObjectReferenceFluentImpl<DockerBuildStrategyFluent.FromNested<N>>
    implements DockerBuildStrategyFluent.FromNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        FromNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        FromNestedImpl() {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this);
        }

        @Override
        public N and() {
            return (N)DockerBuildStrategyFluentImpl.this.withFrom(this.builder.build());
        }

        @Override
        public N endFrom() {
            return this.and();
        }
    }
}

