/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.PowerVSPlatformStatus;
import io.fabric8.openshift.api.model.PowerVSPlatformStatusFluent;
import io.fabric8.openshift.api.model.PowerVSServiceEndpoint;
import io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder;
import io.fabric8.openshift.api.model.PowerVSServiceEndpointFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PowerVSPlatformStatusFluentImpl<A extends PowerVSPlatformStatusFluent<A>>
extends BaseFluent<A>
implements PowerVSPlatformStatusFluent<A> {
    private String cisInstanceCRN;
    private String region;
    private ArrayList<PowerVSServiceEndpointBuilder> serviceEndpoints = new ArrayList();
    private String zone;
    private Map<String, Object> additionalProperties;

    public PowerVSPlatformStatusFluentImpl() {
    }

    public PowerVSPlatformStatusFluentImpl(PowerVSPlatformStatus instance) {
        this.withCisInstanceCRN(instance.getCisInstanceCRN());
        this.withRegion(instance.getRegion());
        this.withServiceEndpoints(instance.getServiceEndpoints());
        this.withZone(instance.getZone());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getCisInstanceCRN() {
        return this.cisInstanceCRN;
    }

    @Override
    public A withCisInstanceCRN(String cisInstanceCRN) {
        this.cisInstanceCRN = cisInstanceCRN;
        return (A)this;
    }

    @Override
    public Boolean hasCisInstanceCRN() {
        return this.cisInstanceCRN != null;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    @Override
    public Boolean hasRegion() {
        return this.region != null;
    }

    @Override
    public A addToServiceEndpoints(Integer index, PowerVSServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        PowerVSServiceEndpointBuilder builder = new PowerVSServiceEndpointBuilder(item);
        this._visitables.get((Object)"serviceEndpoints").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"serviceEndpoints").size(), builder);
        this.serviceEndpoints.add(index >= 0 ? index.intValue() : this.serviceEndpoints.size(), builder);
        return (A)this;
    }

    @Override
    public A setToServiceEndpoints(Integer index, PowerVSServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        PowerVSServiceEndpointBuilder builder = new PowerVSServiceEndpointBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"serviceEndpoints").size()) {
            this._visitables.get((Object)"serviceEndpoints").add(builder);
        } else {
            this._visitables.get((Object)"serviceEndpoints").set(index, builder);
        }
        if (index < 0 || index >= this.serviceEndpoints.size()) {
            this.serviceEndpoints.add(builder);
        } else {
            this.serviceEndpoints.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToServiceEndpoints(PowerVSServiceEndpoint ... items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        for (PowerVSServiceEndpoint item : items) {
            PowerVSServiceEndpointBuilder builder = new PowerVSServiceEndpointBuilder(item);
            this._visitables.get((Object)"serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToServiceEndpoints(Collection<PowerVSServiceEndpoint> items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        for (PowerVSServiceEndpoint item : items) {
            PowerVSServiceEndpointBuilder builder = new PowerVSServiceEndpointBuilder(item);
            this._visitables.get((Object)"serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromServiceEndpoints(PowerVSServiceEndpoint ... items) {
        for (PowerVSServiceEndpoint item : items) {
            PowerVSServiceEndpointBuilder builder = new PowerVSServiceEndpointBuilder(item);
            this._visitables.get((Object)"serviceEndpoints").remove(builder);
            if (this.serviceEndpoints == null) continue;
            this.serviceEndpoints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServiceEndpoints(Collection<PowerVSServiceEndpoint> items) {
        for (PowerVSServiceEndpoint item : items) {
            PowerVSServiceEndpointBuilder builder = new PowerVSServiceEndpointBuilder(item);
            this._visitables.get((Object)"serviceEndpoints").remove(builder);
            if (this.serviceEndpoints == null) continue;
            this.serviceEndpoints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromServiceEndpoints(Predicate<PowerVSServiceEndpointBuilder> predicate) {
        if (this.serviceEndpoints == null) {
            return (A)this;
        }
        Iterator<PowerVSServiceEndpointBuilder> each = this.serviceEndpoints.iterator();
        List visitables = this._visitables.get((Object)"serviceEndpoints");
        while (each.hasNext()) {
            PowerVSServiceEndpointBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PowerVSServiceEndpoint> getServiceEndpoints() {
        return this.serviceEndpoints != null ? PowerVSPlatformStatusFluentImpl.build(this.serviceEndpoints) : null;
    }

    @Override
    public List<PowerVSServiceEndpoint> buildServiceEndpoints() {
        return this.serviceEndpoints != null ? PowerVSPlatformStatusFluentImpl.build(this.serviceEndpoints) : null;
    }

    @Override
    public PowerVSServiceEndpoint buildServiceEndpoint(Integer index) {
        return this.serviceEndpoints.get(index).build();
    }

    @Override
    public PowerVSServiceEndpoint buildFirstServiceEndpoint() {
        return this.serviceEndpoints.get(0).build();
    }

    @Override
    public PowerVSServiceEndpoint buildLastServiceEndpoint() {
        return this.serviceEndpoints.get(this.serviceEndpoints.size() - 1).build();
    }

    @Override
    public PowerVSServiceEndpoint buildMatchingServiceEndpoint(Predicate<PowerVSServiceEndpointBuilder> predicate) {
        for (PowerVSServiceEndpointBuilder item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingServiceEndpoint(Predicate<PowerVSServiceEndpointBuilder> predicate) {
        for (PowerVSServiceEndpointBuilder item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withServiceEndpoints(List<PowerVSServiceEndpoint> serviceEndpoints) {
        if (this.serviceEndpoints != null) {
            this._visitables.get((Object)"serviceEndpoints").removeAll(this.serviceEndpoints);
        }
        if (serviceEndpoints != null) {
            this.serviceEndpoints = new ArrayList();
            for (PowerVSServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        } else {
            this.serviceEndpoints = null;
        }
        return (A)this;
    }

    @Override
    public A withServiceEndpoints(PowerVSServiceEndpoint ... serviceEndpoints) {
        if (this.serviceEndpoints != null) {
            this.serviceEndpoints.clear();
        }
        if (serviceEndpoints != null) {
            for (PowerVSServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasServiceEndpoints() {
        return this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty();
    }

    @Override
    public A addNewServiceEndpoint(String name, String url) {
        return this.addToServiceEndpoints(new PowerVSServiceEndpoint(name, url));
    }

    @Override
    public PowerVSPlatformStatusFluent.ServiceEndpointsNested<A> addNewServiceEndpoint() {
        return new ServiceEndpointsNestedImpl();
    }

    @Override
    public PowerVSPlatformStatusFluent.ServiceEndpointsNested<A> addNewServiceEndpointLike(PowerVSServiceEndpoint item) {
        return new ServiceEndpointsNestedImpl(-1, item);
    }

    @Override
    public PowerVSPlatformStatusFluent.ServiceEndpointsNested<A> setNewServiceEndpointLike(Integer index, PowerVSServiceEndpoint item) {
        return new ServiceEndpointsNestedImpl(index, item);
    }

    @Override
    public PowerVSPlatformStatusFluent.ServiceEndpointsNested<A> editServiceEndpoint(Integer index) {
        if (this.serviceEndpoints.size() <= index) {
            throw new RuntimeException("Can't edit serviceEndpoints. Index exceeds size.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    @Override
    public PowerVSPlatformStatusFluent.ServiceEndpointsNested<A> editFirstServiceEndpoint() {
        if (this.serviceEndpoints.size() == 0) {
            throw new RuntimeException("Can't edit first serviceEndpoints. The list is empty.");
        }
        return this.setNewServiceEndpointLike(0, this.buildServiceEndpoint(0));
    }

    @Override
    public PowerVSPlatformStatusFluent.ServiceEndpointsNested<A> editLastServiceEndpoint() {
        int index = this.serviceEndpoints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last serviceEndpoints. The list is empty.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    @Override
    public PowerVSPlatformStatusFluent.ServiceEndpointsNested<A> editMatchingServiceEndpoint(Predicate<PowerVSServiceEndpointBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.serviceEndpoints.size(); ++i) {
            if (!predicate.test(this.serviceEndpoints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching serviceEndpoints. No match found.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    @Override
    public String getZone() {
        return this.zone;
    }

    @Override
    public A withZone(String zone) {
        this.zone = zone;
        return (A)this;
    }

    @Override
    public Boolean hasZone() {
        return this.zone != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PowerVSPlatformStatusFluentImpl that = (PowerVSPlatformStatusFluentImpl)o;
        if (this.cisInstanceCRN != null ? !this.cisInstanceCRN.equals(that.cisInstanceCRN) : that.cisInstanceCRN != null) {
            return false;
        }
        if (this.region != null ? !this.region.equals(that.region) : that.region != null) {
            return false;
        }
        if (this.serviceEndpoints != null ? !this.serviceEndpoints.equals(that.serviceEndpoints) : that.serviceEndpoints != null) {
            return false;
        }
        if (this.zone != null ? !this.zone.equals(that.zone) : that.zone != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.cisInstanceCRN, this.region, this.serviceEndpoints, this.zone, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cisInstanceCRN != null) {
            sb.append("cisInstanceCRN:");
            sb.append(this.cisInstanceCRN + ",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region + ",");
        }
        if (this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty()) {
            sb.append("serviceEndpoints:");
            sb.append(this.serviceEndpoints + ",");
        }
        if (this.zone != null) {
            sb.append("zone:");
            sb.append(this.zone + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ServiceEndpointsNestedImpl<N>
    extends PowerVSServiceEndpointFluentImpl<PowerVSPlatformStatusFluent.ServiceEndpointsNested<N>>
    implements PowerVSPlatformStatusFluent.ServiceEndpointsNested<N>,
    Nested<N> {
        PowerVSServiceEndpointBuilder builder;
        Integer index;

        ServiceEndpointsNestedImpl(Integer index, PowerVSServiceEndpoint item) {
            this.index = index;
            this.builder = new PowerVSServiceEndpointBuilder(this, item);
        }

        ServiceEndpointsNestedImpl() {
            this.index = -1;
            this.builder = new PowerVSServiceEndpointBuilder(this);
        }

        @Override
        public N and() {
            return (N)PowerVSPlatformStatusFluentImpl.this.setToServiceEndpoints(this.index, this.builder.build());
        }

        @Override
        public N endServiceEndpoint() {
            return this.and();
        }
    }
}

