/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.ClusterRoleBinding;
import io.fabric8.openshift.api.model.ClusterRoleBindingFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterRoleBindingFluentImpl<A extends ClusterRoleBindingFluent<A>>
extends BaseFluent<A>
implements ClusterRoleBindingFluent<A> {
    private String apiVersion;
    private List<String> groupNames = new ArrayList<String>();
    private String kind;
    private ObjectMetaBuilder metadata;
    private ObjectReferenceBuilder roleRef;
    private List<ObjectReferenceBuilder> subjects = new ArrayList<ObjectReferenceBuilder>();
    private List<String> userNames = new ArrayList<String>();

    public ClusterRoleBindingFluentImpl() {
    }

    public ClusterRoleBindingFluentImpl(ClusterRoleBinding instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withGroupNames(instance.getGroupNames());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRoleRef(instance.getRoleRef());
        this.withSubjects(instance.getSubjects());
        this.withUserNames(instance.getUserNames());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public A addToGroupNames(Integer index, String item) {
        if (this.groupNames == null) {
            this.groupNames = new ArrayList<String>();
        }
        this.groupNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToGroupNames(Integer index, String item) {
        if (this.groupNames == null) {
            this.groupNames = new ArrayList<String>();
        }
        this.groupNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToGroupNames(String ... items) {
        if (this.groupNames == null) {
            this.groupNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.groupNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToGroupNames(Collection<String> items) {
        if (this.groupNames == null) {
            this.groupNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.groupNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroupNames(String ... items) {
        for (String item : items) {
            if (this.groupNames == null) continue;
            this.groupNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGroupNames(Collection<String> items) {
        for (String item : items) {
            if (this.groupNames == null) continue;
            this.groupNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGroupNames() {
        return this.groupNames;
    }

    @Override
    public String getGroupName(Integer index) {
        return this.groupNames.get(index);
    }

    @Override
    public String getFirstGroupName() {
        return this.groupNames.get(0);
    }

    @Override
    public String getLastGroupName() {
        return this.groupNames.get(this.groupNames.size() - 1);
    }

    @Override
    public String getMatchingGroupName(Predicate<String> predicate) {
        for (String item : this.groupNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingGroupName(Predicate<String> predicate) {
        for (String item : this.groupNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withGroupNames(List<String> groupNames) {
        if (groupNames != null) {
            this.groupNames = new ArrayList<String>();
            for (String item : groupNames) {
                this.addToGroupNames(item);
            }
        } else {
            this.groupNames = null;
        }
        return (A)this;
    }

    @Override
    public A withGroupNames(String ... groupNames) {
        if (this.groupNames != null) {
            this.groupNames.clear();
        }
        if (groupNames != null) {
            for (String item : groupNames) {
                this.addToGroupNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGroupNames() {
        return this.groupNames != null && !this.groupNames.isEmpty();
    }

    @Override
    public A addNewGroupName(String arg0) {
        return this.addToGroupNames(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ClusterRoleBindingFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ClusterRoleBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ClusterRoleBindingFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ClusterRoleBindingFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ClusterRoleBindingFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public ObjectReference getRoleRef() {
        return this.roleRef != null ? this.roleRef.build() : null;
    }

    @Override
    public ObjectReference buildRoleRef() {
        return this.roleRef != null ? this.roleRef.build() : null;
    }

    @Override
    public A withRoleRef(ObjectReference roleRef) {
        this._visitables.get((Object)"roleRef").remove(this.roleRef);
        if (roleRef != null) {
            this.roleRef = new ObjectReferenceBuilder(roleRef);
            this._visitables.get((Object)"roleRef").add(this.roleRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRoleRef() {
        return this.roleRef != null;
    }

    @Override
    public ClusterRoleBindingFluent.RoleRefNested<A> withNewRoleRef() {
        return new RoleRefNestedImpl();
    }

    @Override
    public ClusterRoleBindingFluent.RoleRefNested<A> withNewRoleRefLike(ObjectReference item) {
        return new RoleRefNestedImpl(item);
    }

    @Override
    public ClusterRoleBindingFluent.RoleRefNested<A> editRoleRef() {
        return this.withNewRoleRefLike(this.getRoleRef());
    }

    @Override
    public ClusterRoleBindingFluent.RoleRefNested<A> editOrNewRoleRef() {
        return this.withNewRoleRefLike(this.getRoleRef() != null ? this.getRoleRef() : new ObjectReferenceBuilder().build());
    }

    @Override
    public ClusterRoleBindingFluent.RoleRefNested<A> editOrNewRoleRefLike(ObjectReference item) {
        return this.withNewRoleRefLike(this.getRoleRef() != null ? this.getRoleRef() : item);
    }

    @Override
    public A addToSubjects(Integer index, ObjectReference item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<ObjectReferenceBuilder>();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        this._visitables.get((Object)"subjects").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"subjects").size(), builder);
        this.subjects.add(index >= 0 ? index.intValue() : this.subjects.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSubjects(Integer index, ObjectReference item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<ObjectReferenceBuilder>();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"subjects").size()) {
            this._visitables.get((Object)"subjects").add(builder);
        } else {
            this._visitables.get((Object)"subjects").set(index, builder);
        }
        if (index < 0 || index >= this.subjects.size()) {
            this.subjects.add(builder);
        } else {
            this.subjects.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSubjects(ObjectReference ... items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<ObjectReferenceBuilder>();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get((Object)"subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubjects(Collection<ObjectReference> items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<ObjectReferenceBuilder>();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get((Object)"subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubjects(ObjectReference ... items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get((Object)"subjects").remove(builder);
            if (this.subjects == null) continue;
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubjects(Collection<ObjectReference> items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get((Object)"subjects").remove(builder);
            if (this.subjects == null) continue;
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSubjects(Predicate<ObjectReferenceBuilder> predicate) {
        if (this.subjects == null) {
            return (A)this;
        }
        Iterator<ObjectReferenceBuilder> each = this.subjects.iterator();
        List visitables = this._visitables.get((Object)"subjects");
        while (each.hasNext()) {
            ObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ObjectReference> getSubjects() {
        return ClusterRoleBindingFluentImpl.build(this.subjects);
    }

    @Override
    public List<ObjectReference> buildSubjects() {
        return ClusterRoleBindingFluentImpl.build(this.subjects);
    }

    @Override
    public ObjectReference buildSubject(Integer index) {
        return this.subjects.get(index).build();
    }

    @Override
    public ObjectReference buildFirstSubject() {
        return this.subjects.get(0).build();
    }

    @Override
    public ObjectReference buildLastSubject() {
        return this.subjects.get(this.subjects.size() - 1).build();
    }

    @Override
    public ObjectReference buildMatchingSubject(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.subjects) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSubject(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.subjects) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSubjects(List<ObjectReference> subjects) {
        if (this.subjects != null) {
            this._visitables.get((Object)"subjects").removeAll(this.subjects);
        }
        if (subjects != null) {
            this.subjects = new ArrayList<ObjectReferenceBuilder>();
            for (ObjectReference item : subjects) {
                this.addToSubjects(item);
            }
        } else {
            this.subjects = null;
        }
        return (A)this;
    }

    @Override
    public A withSubjects(ObjectReference ... subjects) {
        if (this.subjects != null) {
            this.subjects.clear();
        }
        if (subjects != null) {
            for (ObjectReference item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubjects() {
        return this.subjects != null && !this.subjects.isEmpty();
    }

    @Override
    public ClusterRoleBindingFluent.SubjectsNested<A> addNewSubject() {
        return new SubjectsNestedImpl();
    }

    @Override
    public ClusterRoleBindingFluent.SubjectsNested<A> addNewSubjectLike(ObjectReference item) {
        return new SubjectsNestedImpl(-1, item);
    }

    @Override
    public ClusterRoleBindingFluent.SubjectsNested<A> setNewSubjectLike(Integer index, ObjectReference item) {
        return new SubjectsNestedImpl(index, item);
    }

    @Override
    public ClusterRoleBindingFluent.SubjectsNested<A> editSubject(Integer index) {
        if (this.subjects.size() <= index) {
            throw new RuntimeException("Can't edit subjects. Index exceeds size.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public ClusterRoleBindingFluent.SubjectsNested<A> editFirstSubject() {
        if (this.subjects.size() == 0) {
            throw new RuntimeException("Can't edit first subjects. The list is empty.");
        }
        return this.setNewSubjectLike(0, this.buildSubject(0));
    }

    @Override
    public ClusterRoleBindingFluent.SubjectsNested<A> editLastSubject() {
        int index = this.subjects.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subjects. The list is empty.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public ClusterRoleBindingFluent.SubjectsNested<A> editMatchingSubject(Predicate<ObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subjects.size(); ++i) {
            if (!predicate.test(this.subjects.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subjects. No match found.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public A addToUserNames(Integer index, String item) {
        if (this.userNames == null) {
            this.userNames = new ArrayList<String>();
        }
        this.userNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToUserNames(Integer index, String item) {
        if (this.userNames == null) {
            this.userNames = new ArrayList<String>();
        }
        this.userNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToUserNames(String ... items) {
        if (this.userNames == null) {
            this.userNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.userNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToUserNames(Collection<String> items) {
        if (this.userNames == null) {
            this.userNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.userNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromUserNames(String ... items) {
        for (String item : items) {
            if (this.userNames == null) continue;
            this.userNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromUserNames(Collection<String> items) {
        for (String item : items) {
            if (this.userNames == null) continue;
            this.userNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getUserNames() {
        return this.userNames;
    }

    @Override
    public String getUserName(Integer index) {
        return this.userNames.get(index);
    }

    @Override
    public String getFirstUserName() {
        return this.userNames.get(0);
    }

    @Override
    public String getLastUserName() {
        return this.userNames.get(this.userNames.size() - 1);
    }

    @Override
    public String getMatchingUserName(Predicate<String> predicate) {
        for (String item : this.userNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingUserName(Predicate<String> predicate) {
        for (String item : this.userNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withUserNames(List<String> userNames) {
        if (userNames != null) {
            this.userNames = new ArrayList<String>();
            for (String item : userNames) {
                this.addToUserNames(item);
            }
        } else {
            this.userNames = null;
        }
        return (A)this;
    }

    @Override
    public A withUserNames(String ... userNames) {
        if (this.userNames != null) {
            this.userNames.clear();
        }
        if (userNames != null) {
            for (String item : userNames) {
                this.addToUserNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasUserNames() {
        return this.userNames != null && !this.userNames.isEmpty();
    }

    @Override
    public A addNewUserName(String arg0) {
        return this.addToUserNames(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterRoleBindingFluentImpl that = (ClusterRoleBindingFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.groupNames != null ? !this.groupNames.equals(that.groupNames) : that.groupNames != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.roleRef != null ? !this.roleRef.equals((Object)that.roleRef) : that.roleRef != null) {
            return false;
        }
        if (this.subjects != null ? !this.subjects.equals(that.subjects) : that.subjects != null) {
            return false;
        }
        return !(this.userNames != null ? !this.userNames.equals(that.userNames) : that.userNames != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.groupNames, this.kind, this.metadata, this.roleRef, this.subjects, this.userNames, super.hashCode());
    }

    public class SubjectsNestedImpl<N>
    extends ObjectReferenceFluentImpl<ClusterRoleBindingFluent.SubjectsNested<N>>
    implements ClusterRoleBindingFluent.SubjectsNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;
        Integer index;

        SubjectsNestedImpl(Integer index, ObjectReference item) {
            this.index = index;
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        SubjectsNestedImpl() {
            this.index = -1;
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this);
        }

        @Override
        public N and() {
            return (N)ClusterRoleBindingFluentImpl.this.setToSubjects(this.index, this.builder.build());
        }

        @Override
        public N endSubject() {
            return this.and();
        }
    }

    public class RoleRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<ClusterRoleBindingFluent.RoleRefNested<N>>
    implements ClusterRoleBindingFluent.RoleRefNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        RoleRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        RoleRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this);
        }

        @Override
        public N and() {
            return (N)ClusterRoleBindingFluentImpl.this.withRoleRef(this.builder.build());
        }

        @Override
        public N endRoleRef() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ClusterRoleBindingFluent.MetadataNested<N>>
    implements ClusterRoleBindingFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)ClusterRoleBindingFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

