/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.openshift.api.model.NetNamespace;
import io.fabric8.openshift.api.model.NetNamespaceBuilder;
import io.fabric8.openshift.api.model.NetNamespaceFluentImpl;
import io.fabric8.openshift.api.model.NetNamespaceList;
import io.fabric8.openshift.api.model.NetNamespaceListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class NetNamespaceListFluentImpl<A extends NetNamespaceListFluent<A>>
extends BaseFluent<A>
implements NetNamespaceListFluent<A> {
    private String apiVersion;
    private List<NetNamespaceBuilder> items = new ArrayList<NetNamespaceBuilder>();
    private String kind;
    private ListMeta metadata;

    public NetNamespaceListFluentImpl() {
    }

    public NetNamespaceListFluentImpl(NetNamespaceList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToItems(int index, NetNamespace item) {
        if (this.items == null) {
            this.items = new ArrayList<NetNamespaceBuilder>();
        }
        NetNamespaceBuilder builder = new NetNamespaceBuilder(item);
        this._visitables.get((Object)"items").add(index >= 0 ? index : this._visitables.get((Object)"items").size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, NetNamespace item) {
        if (this.items == null) {
            this.items = new ArrayList<NetNamespaceBuilder>();
        }
        NetNamespaceBuilder builder = new NetNamespaceBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"items").size()) {
            this._visitables.get((Object)"items").add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(NetNamespace ... items) {
        if (this.items == null) {
            this.items = new ArrayList<NetNamespaceBuilder>();
        }
        for (NetNamespace item : items) {
            NetNamespaceBuilder builder = new NetNamespaceBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<NetNamespace> items) {
        if (this.items == null) {
            this.items = new ArrayList<NetNamespaceBuilder>();
        }
        for (NetNamespace item : items) {
            NetNamespaceBuilder builder = new NetNamespaceBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(NetNamespace ... items) {
        for (NetNamespace item : items) {
            NetNamespaceBuilder builder = new NetNamespaceBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<NetNamespace> items) {
        for (NetNamespace item : items) {
            NetNamespaceBuilder builder = new NetNamespaceBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<NetNamespaceBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<NetNamespaceBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            NetNamespaceBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NetNamespace> getItems() {
        return NetNamespaceListFluentImpl.build(this.items);
    }

    @Override
    public List<NetNamespace> buildItems() {
        return NetNamespaceListFluentImpl.build(this.items);
    }

    @Override
    public NetNamespace buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public NetNamespace buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public NetNamespace buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public NetNamespace buildMatchingItem(Predicate<NetNamespaceBuilder> predicate) {
        for (NetNamespaceBuilder item : this.items) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<NetNamespaceBuilder> predicate) {
        for (NetNamespaceBuilder item : this.items) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<NetNamespace> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<NetNamespaceBuilder>();
            for (NetNamespace item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(NetNamespace ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (NetNamespace item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public NetNamespaceListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public NetNamespaceListFluent.ItemsNested<A> addNewItemLike(NetNamespace item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public NetNamespaceListFluent.ItemsNested<A> setNewItemLike(int index, NetNamespace item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public NetNamespaceListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public NetNamespaceListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public NetNamespaceListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public NetNamespaceListFluent.ItemsNested<A> editMatchingItem(Predicate<NetNamespaceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.apply((Object)this.items.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetNamespaceListFluentImpl that = (NetNamespaceListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public class ItemsNestedImpl<N>
    extends NetNamespaceFluentImpl<NetNamespaceListFluent.ItemsNested<N>>
    implements NetNamespaceListFluent.ItemsNested<N>,
    Nested<N> {
        private final NetNamespaceBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, NetNamespace item) {
            this.index = index;
            this.builder = new NetNamespaceBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new NetNamespaceBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetNamespaceListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

