/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.openshift.api.model.RouteIngress;
import io.fabric8.openshift.api.model.RouteIngressBuilder;
import io.fabric8.openshift.api.model.RouteIngressFluentImpl;
import io.fabric8.openshift.api.model.RouteStatus;
import io.fabric8.openshift.api.model.RouteStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class RouteStatusFluentImpl<A extends RouteStatusFluent<A>>
extends BaseFluent<A>
implements RouteStatusFluent<A> {
    private List<RouteIngressBuilder> ingress = new ArrayList<RouteIngressBuilder>();

    public RouteStatusFluentImpl() {
    }

    public RouteStatusFluentImpl(RouteStatus instance) {
        this.withIngress(instance.getIngress());
    }

    @Override
    public A addToIngress(int index, RouteIngress item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<RouteIngressBuilder>();
        }
        RouteIngressBuilder builder = new RouteIngressBuilder(item);
        this._visitables.get((Object)"ingress").add(index >= 0 ? index : this._visitables.get((Object)"ingress").size(), builder);
        this.ingress.add(index >= 0 ? index : this.ingress.size(), builder);
        return (A)this;
    }

    @Override
    public A setToIngress(int index, RouteIngress item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<RouteIngressBuilder>();
        }
        RouteIngressBuilder builder = new RouteIngressBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"ingress").size()) {
            this._visitables.get((Object)"ingress").add(builder);
        } else {
            this._visitables.get((Object)"ingress").set(index, builder);
        }
        if (index < 0 || index >= this.ingress.size()) {
            this.ingress.add(builder);
        } else {
            this.ingress.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToIngress(RouteIngress ... items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<RouteIngressBuilder>();
        }
        for (RouteIngress item : items) {
            RouteIngressBuilder builder = new RouteIngressBuilder(item);
            this._visitables.get((Object)"ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToIngress(Collection<RouteIngress> items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<RouteIngressBuilder>();
        }
        for (RouteIngress item : items) {
            RouteIngressBuilder builder = new RouteIngressBuilder(item);
            this._visitables.get((Object)"ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromIngress(RouteIngress ... items) {
        for (RouteIngress item : items) {
            RouteIngressBuilder builder = new RouteIngressBuilder(item);
            this._visitables.get((Object)"ingress").remove(builder);
            if (this.ingress == null) continue;
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIngress(Collection<RouteIngress> items) {
        for (RouteIngress item : items) {
            RouteIngressBuilder builder = new RouteIngressBuilder(item);
            this._visitables.get((Object)"ingress").remove(builder);
            if (this.ingress == null) continue;
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromIngress(Predicate<RouteIngressBuilder> predicate) {
        if (this.ingress == null) {
            return (A)this;
        }
        Iterator<RouteIngressBuilder> each = this.ingress.iterator();
        List visitables = this._visitables.get((Object)"ingress");
        while (each.hasNext()) {
            RouteIngressBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<RouteIngress> getIngress() {
        return RouteStatusFluentImpl.build(this.ingress);
    }

    @Override
    public List<RouteIngress> buildIngress() {
        return RouteStatusFluentImpl.build(this.ingress);
    }

    @Override
    public RouteIngress buildIngress(int index) {
        return this.ingress.get(index).build();
    }

    @Override
    public RouteIngress buildFirstIngress() {
        return this.ingress.get(0).build();
    }

    @Override
    public RouteIngress buildLastIngress() {
        return this.ingress.get(this.ingress.size() - 1).build();
    }

    @Override
    public RouteIngress buildMatchingIngress(Predicate<RouteIngressBuilder> predicate) {
        for (RouteIngressBuilder item : this.ingress) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingIngress(Predicate<RouteIngressBuilder> predicate) {
        for (RouteIngressBuilder item : this.ingress) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withIngress(List<RouteIngress> ingress) {
        if (this.ingress != null) {
            this._visitables.get((Object)"ingress").removeAll(this.ingress);
        }
        if (ingress != null) {
            this.ingress = new ArrayList<RouteIngressBuilder>();
            for (RouteIngress item : ingress) {
                this.addToIngress(item);
            }
        } else {
            this.ingress = null;
        }
        return (A)this;
    }

    @Override
    public A withIngress(RouteIngress ... ingress) {
        if (this.ingress != null) {
            this.ingress.clear();
        }
        if (ingress != null) {
            for (RouteIngress item : ingress) {
                this.addToIngress(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIngress() {
        return this.ingress != null && !this.ingress.isEmpty();
    }

    @Override
    public RouteStatusFluent.IngressNested<A> addNewIngress() {
        return new IngressNestedImpl();
    }

    @Override
    public RouteStatusFluent.IngressNested<A> addNewIngressLike(RouteIngress item) {
        return new IngressNestedImpl(-1, item);
    }

    @Override
    public RouteStatusFluent.IngressNested<A> setNewIngressLike(int index, RouteIngress item) {
        return new IngressNestedImpl(index, item);
    }

    @Override
    public RouteStatusFluent.IngressNested<A> editIngress(int index) {
        if (this.ingress.size() <= index) {
            throw new RuntimeException("Can't edit ingress. Index exceeds size.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public RouteStatusFluent.IngressNested<A> editFirstIngress() {
        if (this.ingress.size() == 0) {
            throw new RuntimeException("Can't edit first ingress. The list is empty.");
        }
        return this.setNewIngressLike(0, this.buildIngress(0));
    }

    @Override
    public RouteStatusFluent.IngressNested<A> editLastIngress() {
        int index = this.ingress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ingress. The list is empty.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public RouteStatusFluent.IngressNested<A> editMatchingIngress(Predicate<RouteIngressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ingress.size(); ++i) {
            if (!predicate.apply((Object)this.ingress.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ingress. No match found.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteStatusFluentImpl that = (RouteStatusFluentImpl)o;
        return !(this.ingress != null ? !this.ingress.equals(that.ingress) : that.ingress != null);
    }

    public class IngressNestedImpl<N>
    extends RouteIngressFluentImpl<RouteStatusFluent.IngressNested<N>>
    implements RouteStatusFluent.IngressNested<N>,
    Nested<N> {
        private final RouteIngressBuilder builder;
        private final int index;

        IngressNestedImpl(int index, RouteIngress item) {
            this.index = index;
            this.builder = new RouteIngressBuilder(this, item);
        }

        IngressNestedImpl() {
            this.index = -1;
            this.builder = new RouteIngressBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteStatusFluentImpl.this.setToIngress(this.index, this.builder.build());
        }

        @Override
        public N endIngress() {
            return this.and();
        }
    }
}

