/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.OAuthSpec;
import io.fabric8.openshift.api.model.OAuthSpecFluent;
import io.fabric8.openshift.api.model.OAuthSpecFluentImpl;

public class OAuthSpecBuilder
extends OAuthSpecFluentImpl<OAuthSpecBuilder>
implements VisitableBuilder<OAuthSpec, OAuthSpecBuilder> {
    OAuthSpecFluent<?> fluent;
    Boolean validationEnabled;

    public OAuthSpecBuilder() {
        this(true);
    }

    public OAuthSpecBuilder(Boolean validationEnabled) {
        this(new OAuthSpec(), validationEnabled);
    }

    public OAuthSpecBuilder(OAuthSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public OAuthSpecBuilder(OAuthSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new OAuthSpec(), validationEnabled);
    }

    public OAuthSpecBuilder(OAuthSpecFluent<?> fluent, OAuthSpec instance) {
        this(fluent, instance, true);
    }

    public OAuthSpecBuilder(OAuthSpecFluent<?> fluent, OAuthSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withIdentityProviders(instance.getIdentityProviders());
        fluent.withTemplates(instance.getTemplates());
        fluent.withTokenConfig(instance.getTokenConfig());
        this.validationEnabled = validationEnabled;
    }

    public OAuthSpecBuilder(OAuthSpec instance) {
        this(instance, (Boolean)true);
    }

    public OAuthSpecBuilder(OAuthSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withIdentityProviders(instance.getIdentityProviders());
        this.withTemplates(instance.getTemplates());
        this.withTokenConfig(instance.getTokenConfig());
        this.validationEnabled = validationEnabled;
    }

    public OAuthSpec build() {
        OAuthSpec buildable = new OAuthSpec(this.fluent.getIdentityProviders(), this.fluent.getTemplates(), this.fluent.getTokenConfig());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuthSpecBuilder that = (OAuthSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

